/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.op;

import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.OperationException;
import ca.uwaterloo.cs.jgrok.interp.Value;
import java.util.regex.PatternSyntaxException;

public class StringOperation
extends Operation {
    @Override
    public Value eval(int op, Value v) throws OperationException {
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, String.class));
    }

    @Override
    public Value eval(int op, Value left, Value right) throws OperationException {
        String l = left.toString();
        String r = right.toString();
        try {
            switch (op) {
                case 2: {
                    return new Value(l.compareTo(r) == 0);
                }
                case 5: {
                    return new Value(l.compareTo(r) != 0);
                }
                case 0: {
                    return new Value(l.compareTo(r) > 0);
                }
                case 4: {
                    return new Value(l.compareTo(r) >= 0);
                }
                case 1: {
                    return new Value(l.compareTo(r) < 0);
                }
                case 3: {
                    return new Value(l.compareTo(r) <= 0);
                }
                case 6: {
                    return new Value(l.matches(r));
                }
                case 7: {
                    return new Value(!l.matches(r));
                }
                case 12: {
                    return new Value(l + r);
                }
            }
        }
        catch (PatternSyntaxException e) {
            throw new OperationException(e.getMessage());
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, String.class, String.class));
    }
}

