/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.op;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.OperationException;
import ca.uwaterloo.cs.jgrok.interp.Value;

public class TupleSetOperation
extends Operation {
    @Override
    public Value eval(int op, Value v) throws OperationException {
        TupleSet tSet = (TupleSet)v.objectValue();
        switch (op) {
            case 27: {
                return new Value(tSet.size());
            }
            case 32: {
                return new Value(AlgebraOperation.id(tSet));
            }
            case 33: {
                return new Value(AlgebraOperation.inverse(tSet));
            }
            case 36: {
                return new Value(AlgebraOperation.entityOf(tSet));
            }
            case 34: {
                return new Value(AlgebraOperation.domainOf(tSet));
            }
            case 35: {
                return new Value(AlgebraOperation.rangeOf(tSet));
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, v.getType()));
    }

    @Override
    public Value eval(int op, Value left, Value right) throws OperationException {
        if (op == 8) {
            TupleSet tSet = (TupleSet)right.objectValue();
            if (tSet instanceof NodeSet) {
                return new Value(((NodeSet)tSet).contain(left.toString()));
            }
        } else {
            TupleSet l = (TupleSet)left.objectValue();
            TupleSet r = (TupleSet)right.objectValue();
            switch (op) {
                case 12: {
                    return new Value(AlgebraOperation.union(l, r));
                }
                case 13: {
                    return new Value(AlgebraOperation.difference(l, r));
                }
                case 16: {
                    return new Value(AlgebraOperation.composition(l, r));
                }
                case 15: {
                    return new Value(AlgebraOperation.composition(l, r));
                }
                case 17: {
                    return new Value(AlgebraOperation.compositionRel(l, r));
                }
                case 14: {
                    return new Value(AlgebraOperation.intersection(l, r));
                }
            }
        }
        throw new OperationException(ErrorMessage.errUnsupportedOperation(op, left.getType(), right.getType()));
    }
}

