/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.select;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.interp.select.ColumnNode;
import ca.uwaterloo.cs.jgrok.interp.select.SelectContext;

public class ColumnAttributeNode
extends ColumnNode {
    String attName;
    EdgeSet attSet;
    SelectContext context;

    public ColumnAttributeNode(int col, String attName) {
        super(col);
        this.attName = attName;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        if (userObj == null) {
            this.attSet = null;
            this.context = null;
            return;
        }
        if (userObj instanceof SelectContext) {
            this.context = (SelectContext)userObj;
            try {
                String name = "@" + this.attName;
                Variable var = env.lookup(name);
                if (var.getType() != EdgeSet.class) {
                    throw new EvaluationException((SyntaxTreeNode)this, "attribute was not eset: " + name);
                }
                this.attSet = (EdgeSet)var.getValue().objectValue();
            }
            catch (LookupException e) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Tuple t = this.context.getTuple();
        if (this.col < t.size()) {
            String s = this.attSet.getAttribute(t.get(this.col));
            if (s == null) {
                return Value.VOID;
            }
            return new Value(s);
        }
        throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errIndexOutOfBounds(this.col, t.size()));
    }

    @Override
    public String toString() {
        return "&" + this.col + "." + this.attName;
    }
}

