/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.select;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.select.SelectContext;

public class ColumnNode
extends ExpressionNode {
    int col;
    String numSign = null;
    boolean positive = true;
    SelectContext context;

    public ColumnNode() {
        this.numSign = "#";
    }

    public ColumnNode(int col) {
        this.col = col;
    }

    public int getColumn() {
        return this.col;
    }

    public void setPositive(boolean b) {
        this.positive = b;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        if (userObj == null) {
            this.context = null;
            return;
        }
        if (userObj instanceof SelectContext) {
            this.context = (SelectContext)userObj;
        }
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        if (this.numSign == null) {
            if (this.positive) {
                if (this.context == null) {
                    return new Value(this.col);
                }
                Tuple t = this.context.getTuple();
                if (t == null) {
                    throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errNotInterpretable(this.toString()));
                }
                if (this.col < t.size()) {
                    String s = IDManager.get(t.get(this.col));
                    if (s == null) {
                        return Value.VOID;
                    }
                    return new Value(s);
                }
                throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errIndexOutOfBounds(this.col, t.size()));
            }
            if (this.context == null) {
                return new Value(0 - this.col);
            }
            Tuple t = this.context.getTuple();
            if (t == null) {
                throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errNotInterpretable(this.toString()));
            }
            if (this.col < t.size()) {
                String s = IDManager.get(t.get(t.size() - 1 - this.col));
                if (s == null) {
                    return Value.VOID;
                }
                return new Value(s);
            }
            throw new EvaluationException((SyntaxTreeNode)this, ErrorMessage.errIndexOutOfBounds(t.size() - 1 - this.col, t.size()));
        }
        if (this.context == null) {
            return new Value(this.numSign);
        }
        Tuple t = this.context.getTuple();
        if (t == null) {
            return new Value(0);
        }
        return new Value(t.size());
    }

    public String toString() {
        if (this.numSign == null) {
            if (this.positive) {
                return "&" + this.col;
            }
            return "&-" + this.col;
        }
        return "&#";
    }
}

