/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.select;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.select.SelectConditionNode;
import ca.uwaterloo.cs.jgrok.interp.select.SelectContext;
import ca.uwaterloo.cs.jgrok.interp.select.SelectTupleNode;

public class SelectExpressionNode
extends ExpressionNode
implements SelectContext {
    ExpressionNode exp;
    SelectConditionNode cond;
    private Tuple catchedTuple;

    public SelectExpressionNode(ExpressionNode exp, SelectConditionNode cond) {
        this.exp = exp;
        this.cond = cond;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.exp.toString());
        buf.append('[');
        buf.append(this.cond.toString());
        buf.append(']');
        return buf.toString();
    }

    @Override
    public Tuple getTuple() {
        return this.catchedTuple;
    }

    @Override
    public void setTuple(Tuple t) {
        this.catchedTuple = t;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.exp.propagate(env, userObj);
        this.cond.propagate(env, userObj);
    }

    @Override
    public Value evaluate(Env env) throws EvaluationException {
        Value expVal = this.exp.evaluate(env);
        if (expVal.objectValue() instanceof TupleSet) {
            TupleSet tSet = (TupleSet)expVal.objectValue();
            if (this.cond instanceof SelectTupleNode) {
                return new Value(((SelectTupleNode)this.cond).evaluate(tSet));
            }
            TupleSet result = this.cond.evaluate(env, tSet);
            if (tSet.hasName()) {
                result = (TupleSet)result.clone();
            }
            return new Value(result);
        }
        String msg = ErrorMessage.errIllegalExpression(expVal.getType(), TupleSet.class);
        throw new EvaluationException((SyntaxTreeNode)this.exp, msg);
    }
}

