/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.select;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.select.SelectConditionNode;

public class SelectOrExpressionNode
extends SelectConditionNode {
    SelectConditionNode left;
    SelectConditionNode right;

    public SelectOrExpressionNode(SelectConditionNode left, SelectConditionNode right) {
        this.left = left;
        this.right = right;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.left.propagate(env, userObj);
        this.right.propagate(env, userObj);
    }

    @Override
    public TupleSet evaluate(Env env, TupleSet tSet) throws EvaluationException {
        TupleSet leftSet = this.left.evaluate(env, tSet);
        TupleSet rightSet = this.right.evaluate(env, tSet);
        return AlgebraOperation.union(leftSet, rightSet);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.left.toString());
        buf.append(" || ");
        buf.append(this.right.toString());
        return buf.toString();
    }
}

