/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.select;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleFactory;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.select.ColumnNode;
import ca.uwaterloo.cs.jgrok.interp.select.SelectConditionNode;
import java.util.ArrayList;

public class SelectProjectionNode
extends SelectConditionNode {
    ArrayList<ColumnNode> columnList;

    public SelectProjectionNode(ArrayList<ColumnNode> columnList) {
        this.columnList = columnList;
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        for (int i = 0; i < this.columnList.size(); ++i) {
            ColumnNode column = this.columnList.get(i);
            column.propagate(env, userObj);
        }
    }

    @Override
    public TupleSet evaluate(Env env, TupleSet tSet) throws EvaluationException {
        TupleSet result;
        int[] indexes = new int[this.columnList.size()];
        for (int i = 0; i < this.columnList.size(); ++i) {
            ColumnNode column = this.columnList.get(i);
            indexes[i] = column.evaluate(env).intValue();
        }
        switch (indexes.length) {
            case 1: {
                result = new NodeSet(tSet.size());
                break;
            }
            case 2: {
                result = new EdgeSet(tSet.size());
                break;
            }
            default: {
                result = new TupleSet(tSet.size());
            }
        }
        for (int i = 0; i < tSet.size(); ++i) {
            try {
                Tuple t = tSet.get(i);
                result.add(TupleFactory.create(t.get(indexes), false));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        result.removeDuplicates();
        return result;
    }

    public String toString() {
        ColumnNode column = this.columnList.get(0);
        StringBuffer buf = new StringBuffer();
        buf.append(column);
        for (int i = 1; i < this.columnList.size(); ++i) {
            column = this.columnList.get(i);
            buf.append(", ");
            buf.append(column);
        }
        return buf.toString();
    }
}

