/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.interp.select;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.ErrorMessage;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.ExpressionNode;
import ca.uwaterloo.cs.jgrok.interp.Operation;
import ca.uwaterloo.cs.jgrok.interp.Operator;
import ca.uwaterloo.cs.jgrok.interp.SyntaxTreeNode;
import ca.uwaterloo.cs.jgrok.interp.TypeOperation;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.ValueMath;
import ca.uwaterloo.cs.jgrok.interp.select.SelectContextNode;
import java.util.regex.PatternSyntaxException;

public class SelectRelationalExpressionNode
extends SelectContextNode {
    int op;
    ExpressionNode left;
    ExpressionNode right;

    public SelectRelationalExpressionNode(int op, ExpressionNode left, ExpressionNode right) {
        this.op = op;
        this.left = left;
        this.right = right;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.left.toString());
        buf.append(' ');
        buf.append(Operator.key(this.op));
        buf.append(' ');
        buf.append(this.right.toString());
        return buf.toString();
    }

    @Override
    public void propagate(Env env, Object userObj) throws EvaluationException {
        this.left.propagate(env, userObj);
        this.right.propagate(env, userObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleSet evaluate(Env env, TupleSet tSet) throws EvaluationException {
        if (tSet.size() == 0) {
            return tSet;
        }
        try {
            this.left.propagate(env, this);
            this.right.propagate(env, this);
            if (this.op == 8) {
                TupleSet tupleSet = this.evalSetMembership(env, tSet);
                return tupleSet;
            }
            TupleSet tupleSet = this.evalRelationalMath(env, tSet);
            return tupleSet;
        }
        finally {
            this.setTuple(null);
            this.left.propagate(env, null);
            this.right.propagate(env, null);
        }
    }

    private TupleSet evalSetMembership(Env env, TupleSet tSet) throws EvaluationException {
        Value vRight = this.right.evaluate(env);
        Object o = vRight.objectValue();
        if (!(o instanceof NodeSet)) {
            throw new EvaluationException((SyntaxTreeNode)this.right, "not a set");
        }
        NodeSet set = (NodeSet)o;
        TupleSet result = tSet.newSet();
        TupleList tList = tSet.getTupleList();
        int count = tList.size();
        for (int i = 0; i < count; ++i) {
            this.setTuple(tList.get(i));
            Value vLeft = this.left.evaluate(env);
            if (vLeft == Value.VOID || !set.contain(vLeft.toString())) continue;
            result.add(this.getTuple());
        }
        return result;
    }

    private TupleSet evalRelationalMath(Env env, TupleSet tSet) throws EvaluationException {
        Operation operation = null;
        TupleSet result = tSet.newSet();
        TupleList tList = tSet.getTupleList();
        int count = tList.size();
        for (int i = 0; i < count; ++i) {
            Value val;
            this.setTuple(tList.get(i));
            Value vLeft = this.left.evaluate(env);
            Value vRight = this.right.evaluate(env);
            if (vLeft == Value.VOID || vRight == Value.VOID) continue;
            try {
                val = ValueMath.eval(this.op, vLeft, vRight);
                if (!val.booleanValue()) continue;
                result.add(this.getTuple());
                continue;
            }
            catch (PatternSyntaxException e) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
            catch (EvaluationException e) {
                try {
                    if (operation == null) {
                        operation = this.getOperation(vLeft, vRight);
                    }
                    if (!(val = operation.eval(this.op, vLeft, vRight)).booleanValue()) continue;
                    result.add(this.getTuple());
                    continue;
                }
                catch (Exception ex) {
                    throw new EvaluationException((SyntaxTreeNode)this, ex.getMessage());
                }
            }
        }
        return result;
    }

    private Operation getOperation(Value vLeft, Value vRight) throws EvaluationException {
        TypeOperation TOP = TypeOperation.analyze(this.op, vLeft.getType(), vRight.getType());
        if (TOP != null) {
            try {
                return TOP.getOperation();
            }
            catch (Exception e) {
                throw new EvaluationException((SyntaxTreeNode)this, e.getMessage());
            }
        }
        String err = ErrorMessage.errUnsupportedOperation(this.op, vLeft.getType(), vRight.getType());
        throw new EvaluationException((SyntaxTreeNode)this, err);
    }
}

