/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.io;

import ca.uwaterloo.cs.jgrok.fb.Factbase;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.io.FactbaseReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;

public class CSVFileReader
implements FactbaseReader {
    @Override
    public Factbase read(String dataFile) throws FileNotFoundException {
        Factbase factbase = new Factbase(dataFile);
        TupleSet tSet = new TupleSet("CSVDATA");
        factbase.addSet(tSet);
        try {
            File file = new File(dataFile);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int lineNum = 0;
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() > 0) {
                    String[] elems = this.separate(line);
                    tSet.add(elems);
                }
                ++lineNum;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return factbase;
    }

    private String[] separate(String line) {
        char prev = line.charAt(0);
        int length = line.length();
        boolean quoted = false;
        ArrayList<String> list = new ArrayList<String>(7);
        int bgnIndex = -1;
        int endIndex = -1;
        for (int i = 0; i < length; ++i) {
            char curr = line.charAt(i);
            switch (curr) {
                case '\t': 
                case ' ': {
                    if (quoted) break;
                    if (prev != ',') {
                        endIndex = i;
                    }
                    ++i;
                    while (i < length && (line.charAt(i) == ' ' || line.charAt(i) == '\t')) {
                        ++i;
                    }
                    if (line.charAt(i) != ',') {
                        --i;
                    } else if (bgnIndex < 0) {
                        --i;
                    }
                    curr = line.charAt(i);
                    break;
                }
                case '\"': {
                    if (!quoted) {
                        quoted = true;
                    } else if (prev != '\\') {
                        quoted = false;
                    }
                    if (bgnIndex >= 0) break;
                    bgnIndex = i;
                    break;
                }
                case ',': {
                    if (quoted) break;
                    endIndex = i;
                    break;
                }
                default: {
                    if (bgnIndex >= 0) break;
                    bgnIndex = i;
                }
            }
            if (0 <= bgnIndex && bgnIndex <= endIndex) {
                list.add(line.substring(bgnIndex, endIndex));
                bgnIndex = -1;
                endIndex = -1;
            } else if (-1 == bgnIndex && 0 <= endIndex) {
                list.add("");
                bgnIndex = -1;
                endIndex = -1;
            }
            prev = curr;
        }
        if (0 <= bgnIndex && bgnIndex < length) {
            list.add(line.substring(bgnIndex, length));
        }
        String[] result = new String[list.size()];
        list.toArray(result);
        return result;
    }
}

