/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.io;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.Factbase;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.io.FactbaseReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class RSFFileReader
implements FactbaseReader {
    @Override
    public Factbase read(String dataFile) throws FileNotFoundException {
        Factbase factbase = new Factbase(dataFile);
        try {
            String line;
            File file = new File(dataFile);
            StringBuffer buffer = new StringBuffer();
            BufferedReader reader = new BufferedReader(new FileReader(file));
            int lineNum = 1;
            while ((line = reader.readLine()) != null) {
                String name;
                if (line.length() == 0) {
                    ++lineNum;
                    continue;
                }
                StringTokenizer tokenizer = new StringTokenizer(line);
                int tokCount = tokenizer.countTokens();
                if (tokCount == 3) {
                    name = tokenizer.nextToken();
                    EdgeSet eSet = factbase.getEdgeSet(name);
                    if (eSet == null) {
                        eSet = new EdgeSet(name);
                        factbase.addSet(eSet);
                    }
                    eSet.add(tokenizer.nextToken(), tokenizer.nextToken());
                } else if (tokCount == 2) {
                    name = tokenizer.nextToken();
                    NodeSet nSet = factbase.getNodeSet(name);
                    if (nSet == null) {
                        nSet = new NodeSet(name);
                        factbase.addSet(nSet);
                    }
                    nSet.add(tokenizer.nextToken());
                } else if (tokCount > 3) {
                    buffer.delete(0, buffer.length());
                    name = tokenizer.nextToken();
                    TupleSet tSet = factbase.getSet(name);
                    if (tSet == null) {
                        tSet = new TupleSet(name);
                        factbase.addSet(tSet);
                    }
                    String[] elems = new String[tokCount - 1];
                    for (int i = 0; i < elems.length; ++i) {
                        elems[i] = tokenizer.nextToken();
                    }
                    tSet.add(elems);
                } else {
                    System.err.println(">> File: " + dataFile + " line: " + lineNum + " not processed");
                    System.err.println(line);
                }
                ++lineNum;
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return factbase;
    }
}

