/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.io;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.Factbase;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.io.FactbaseWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;

public class RSFFileWriter
implements FactbaseWriter {
    @Override
    public void write(String fileName, Factbase factbase) throws IOException {
        String name;
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        } else if (file.isDirectory()) {
            throw new IOException("File " + fileName + " is a directory");
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        PrintWriter writer = new PrintWriter(fileOut);
        Enumeration<TupleSet> en1 = factbase.allSets();
        while (en1.hasMoreElements()) {
            TupleSet set = en1.nextElement();
            name = set.getName();
            if (name.startsWith("@")) continue;
            set.printRSF(name, writer);
        }
        Enumeration<EdgeSet> en2 = factbase.allEdgeSets();
        while (en2.hasMoreElements()) {
            EdgeSet eset = en2.nextElement();
            name = eset.getName();
            if (!name.startsWith("@")) continue;
            eset.printRSF(writer);
        }
    }
}

