/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.io;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.Factbase;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.io.FactbaseWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;

public class TAFileWriter
implements FactbaseWriter {
    @Override
    public void write(String fileName, Factbase factbase) throws IOException {
        TupleSet set;
        File file = new File(fileName);
        if (!file.exists()) {
            file.createNewFile();
        } else if (file.isDirectory()) {
            throw new IOException("File " + fileName + " is a directory");
        }
        FileOutputStream fileOut = new FileOutputStream(file);
        PrintWriter writer = new PrintWriter(fileOut);
        Hashtable attributes = new Hashtable();
        writer.println("SCHEME TUPLE :");
        writer.println();
        String name = "$INHERIT";
        TupleSet inherit = factbase.getSet(name);
        if (inherit != null) {
            inherit.printTA(name, writer);
            writer.println();
        }
        TupleSet instance = factbase.getSet("$INSTANCE");
        Enumeration<TupleSet> en1 = factbase.allSets();
        while (en1.hasMoreElements()) {
            set = en1.nextElement();
            if (set == inherit || set == instance || (name = set.getName()).length() <= 0 || name.charAt(0) != '$') continue;
            if ((name = name.substring(1)).charAt(0) == '_') {
                name = name.substring(1);
            }
            set.printTA(name, writer);
        }
        writer.println();
        writer.println("SCHEME ATTRIBUTE :");
        writer.println();
        Enumeration<EdgeSet> en2 = factbase.allEdgeSets();
        while (en2.hasMoreElements()) {
            EdgeSet eset = en2.nextElement();
            name = eset.getName();
            if (name.length() <= 0 || name.charAt(0) != '@') continue;
            this.putAttributes(name, eset, attributes);
        }
        this.printAttributes(attributes, true, writer);
        writer.println();
        writer.println("FACT TUPLE :");
        writer.println();
        if (instance != null) {
            instance.printTA("$INSTANCE", writer);
            writer.println();
        }
        en1 = factbase.allSets();
        while (en1.hasMoreElements()) {
            set = en1.nextElement();
            name = set.getName();
            if (name.length() != 0 && (name.charAt(0) == '$' || name.charAt(0) == '@')) continue;
            set.printTA(name, writer);
        }
        writer.println();
        writer.println("FACT ATTRIBUTE :");
        writer.println();
        this.printAttributes(attributes, false, writer);
        attributes.clear();
        writer.close();
    }

    private void putAttributes(String name, EdgeSet eset, Hashtable attributes) {
        int size = eset.size();
        for (int i = 0; i < size; ++i) {
            Tuple tuple = eset.get(i);
            String id = IDManager.get(tuple.getDom());
            String value = IDManager.get(tuple.getRng());
            EdgeSet values = (EdgeSet)attributes.get(id);
            if (values == null) {
                values = new EdgeSet(id);
                attributes.put(id, values);
            }
            values.add(name, value);
        }
    }

    private void printAttributes(Hashtable attributes, boolean schema, PrintWriter writer) {
        EdgeSet values;
        if (!schema && (values = (EdgeSet)attributes.get("$ROOT")) != null) {
            this.printAttributes(false, "$ROOT", values, writer);
        }
        Enumeration en = attributes.elements();
        while (en.hasMoreElements()) {
            values = (EdgeSet)en.nextElement();
            String name = values.getName();
            if (name.charAt(0) == '$') {
                if (name.equals("$ROOT") || !schema) continue;
                name = name.substring(1);
            } else if (schema) continue;
            this.printAttributes(schema, name, values, writer);
        }
    }

    private void printAttributes(boolean schema, String name, EdgeSet values, PrintWriter writer) {
        if (name.charAt(0) == '_') {
            writer.print('(');
            writer.print(name.substring(1));
            writer.print(')');
        } else {
            writer.print(name);
        }
        writer.println(" {");
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            Tuple tuple = values.get(i);
            writer.print("  ");
            name = IDManager.get(tuple.getDom());
            writer.print(name.substring(1));
            int rng = tuple.getRng();
            if (!schema || rng != 0) {
                String value = IDManager.get(rng);
                writer.print("=");
                writer.print(value);
            }
            writer.println();
        }
        writer.println("}");
    }
}

