/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.io.ta;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.Factbase;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.io.ta.AttributeSettingNode;
import ca.uwaterloo.cs.jgrok.io.ta.ItemIdNode;
import java.util.ArrayList;
import java.util.HashMap;

class AttributeNode {
    ItemIdNode item;
    ArrayList<AttributeSettingNode> settings;

    public void dump(int indent) {
        int i;
        for (i = 0; i < indent; ++i) {
            System.out.print(' ');
        }
        System.out.println("AttributeNode");
        if (this.item != null) {
            this.item.dump(indent + 2);
        }
        int size = this.settings == null ? 0 : this.settings.size();
        for (i = 0; i < size; ++i) {
            AttributeSettingNode settingNd = this.settings.get(i);
            settingNd.dump(indent + 2);
        }
    }

    AttributeNode(ItemIdNode item) {
        this.item = item;
        this.settings = new ArrayList();
    }

    void add(AttributeSettingNode setting) {
        this.settings.add(setting);
    }

    void putInto(Factbase factbase) {
        int size = this.settings.size();
        for (int i = 0; i < size; ++i) {
            AttributeSettingNode settingNd = this.settings.get(i);
            HashMap<String, String> allAttributes = settingNd.allAttributes();
            for (String attrId : allAttributes.keySet()) {
                String value = allAttributes.get(attrId);
                String attrRel = "@" + attrId;
                EdgeSet aSet = factbase.getEdgeSet(attrRel);
                if (aSet == null) {
                    aSet = new EdgeSet(attrRel);
                    factbase.addSet(aSet);
                }
                aSet.add(this.item.itemID(), IDManager.getID(value));
            }
        }
    }

    void putIntoScheme(Factbase factbase) {
        int size = this.settings.size();
        for (int i = 0; i < size; ++i) {
            AttributeSettingNode settingNd = this.settings.get(i);
            HashMap<String, String> allAttributes = settingNd.allAttributes();
            for (String attrId : allAttributes.keySet()) {
                String value = allAttributes.get(attrId);
                String attrRel = "$@" + attrId;
                EdgeSet aSet = factbase.getEdgeSet(attrRel);
                if (aSet == null) {
                    aSet = new EdgeSet(attrRel);
                    factbase.addSet(aSet);
                }
                aSet.add(this.item.itemID(), IDManager.getID(value));
            }
        }
    }

    public String toString() {
        return this.item.toString();
    }
}

