/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.io.ta;

import ca.uwaterloo.cs.jgrok.fb.Factbase;
import ca.uwaterloo.cs.jgrok.io.FactbaseReader;
import ca.uwaterloo.cs.jgrok.io.ta.AttributeNode;
import ca.uwaterloo.cs.jgrok.io.ta.AttributeSettingNode;
import ca.uwaterloo.cs.jgrok.io.ta.FactNode;
import ca.uwaterloo.cs.jgrok.io.ta.ItemIdNode;
import ca.uwaterloo.cs.jgrok.io.ta.StringCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.jar.JarInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class TAFileReader
implements FactbaseReader {
    private static final byte CT_DELIMIT = 2;
    private static final byte CT_QUOTE = 3;
    public static final int TT_EOF = -1;
    public static final int TT_WORD = -2;
    private static char[] m_ctype;
    private LineNumberReader m_reader;
    private String m_filename;
    private int m_peekc = 32;
    private boolean m_pushedBack;
    private boolean m_escaped;
    private int m_buf_size = 20480;
    private char[] m_buf = new char[this.m_buf_size];
    private int m_ttype = 32;
    private String m_sval;
    public static final int SCHEME_TUPLE = 0;
    public static final int SCHEME_ATTRIBUTE = 1;
    public static final int FACT_TUPLE = 2;
    public static final int FACT_ATTRIBUTE = 3;
    public static final int ERROR = -1;
    public static final int NONE = -2;
    public static final int EOF = 99;
    public static final String INSTANCE_ID = "$INSTANCE";
    public static final String INHERIT_RELN = "$INHERIT";
    public static final String CONTAIN_ID = "contain";
    public static final String ROOT_ID = "$ROOT";
    public static final String SCHEME_ID = "SCHEME";
    public static final String FACT_ID = "FACT";
    public static final String TUPLE_ID = "TUPLE";
    public static final String ATTRIBUTE_ID = "ATTRIBUTE";
    public static boolean m_strict_TA;
    private Object m_context;
    private String m_zipEntry;
    protected Factbase m_factbase = null;
    protected String m_resString = null;
    protected boolean m_fatalError = false;
    protected String m_token1;
    protected String m_token2;
    protected int m_ttype3;
    public String m_verb;
    public String m_object;
    public String m_subject;
    public int m_relations;
    protected int m_startLineno = -1;

    private final String filename() {
        return this.m_filename;
    }

    private final int lineno() {
        return this.m_reader.getLineNumber();
    }

    private final int charToken() throws IOException {
        int c = this.m_peekc;
        this.m_peekc = this.m_reader.read();
        switch (c) {
            case 92: {
                switch (this.m_peekc) {
                    case 110: {
                        c = 10;
                        break;
                    }
                    case 116: {
                        c = 9;
                        break;
                    }
                    case 102: {
                        c = 12;
                        break;
                    }
                    case 114: {
                        c = 13;
                        break;
                    }
                    case 101: {
                        c = 27;
                        break;
                    }
                    case 100: {
                        c = 127;
                    }
                    case 92: {
                        this.m_peekc = 32;
                        break;
                    }
                    case 34: {
                        c = 34;
                        this.m_escaped = true;
                        break;
                    }
                    case 39: {
                        c = 39;
                        this.m_escaped = true;
                        break;
                    }
                    default: {
                        c = this.m_peekc;
                    }
                }
                this.charToken();
                break;
            }
            case 34: 
            case 39: {
                this.m_escaped = false;
            }
        }
        return c;
    }

    protected final void pushBack(int ttype) {
        this.m_ttype = ttype;
        this.m_pushedBack = true;
    }

    public final int nextToken() throws IOException {
        int c;
        if (this.m_pushedBack) {
            this.m_pushedBack = false;
            return this.m_ttype;
        }
        int pos = 0;
        this.m_sval = null;
        block27: while (true) {
            c = this.charToken();
            switch (c) {
                case -1: {
                    return -1;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    continue block27;
                }
                case 34: {
                    block28: while (true) {
                        c = this.charToken();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated \" in input");
                            }
                            case 34: {
                                if (!this.m_escaped) break block28;
                            }
                            default: {
                                if (pos >= this.m_buf_size) {
                                    int new_buf_size = this.m_buf_size * 2;
                                    char[] new_buf = new char[new_buf_size];
                                    System.arraycopy(this.m_buf, 0, new_buf, 0, this.m_buf_size);
                                    this.m_buf_size = new_buf_size;
                                    this.m_buf = new_buf;
                                }
                                this.m_buf[pos++] = (char)c;
                                continue block28;
                            }
                        }
                        break;
                    }
                    this.m_sval = StringCache.get(this.m_buf, pos);
                    return -2;
                }
                case 39: {
                    block29: while (true) {
                        c = this.charToken();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated ' in input");
                                break block29;
                            }
                            case 39: {
                                if (!this.m_escaped) break block29;
                            }
                            default: {
                                if (pos >= this.m_buf_size) {
                                    int new_buf_size = this.m_buf_size * 2;
                                    char[] new_buf = new char[new_buf_size];
                                    System.arraycopy(this.m_buf, 0, new_buf, 0, this.m_buf_size);
                                    this.m_buf_size = new_buf_size;
                                    this.m_buf = new_buf;
                                }
                                this.m_buf[pos++] = (char)c;
                                continue block29;
                            }
                        }
                        break;
                    }
                    this.m_sval = StringCache.get(this.m_buf, pos);
                    return -2;
                }
                case 47: {
                    switch (this.m_peekc) {
                        case 47: {
                            block30: while (true) {
                                c = this.charToken();
                                switch (c) {
                                    case 13: {
                                        if (this.m_peekc == 10) continue block30;
                                    }
                                    case -1: 
                                    case 10: {
                                        continue block27;
                                    }
                                }
                            }
                        }
                        case 42: {
                            block31: while (true) {
                                c = this.charToken();
                                switch (c) {
                                    case 42: {
                                        if (this.m_peekc != 47) continue block31;
                                        c = this.charToken();
                                    }
                                    case -1: {
                                        continue block27;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            break;
        }
        if (c < m_ctype.length && m_ctype[c] == '\u0002') {
            this.m_sval = String.valueOf((char)c);
            return c;
        }
        while (true) {
            this.m_buf[pos++] = (char)c;
            if (this.m_peekc == -1) break;
            if (c == 92) {
                this.m_buf[pos++] = (char)this.charToken();
            }
            if (c < m_ctype.length && m_ctype[this.m_peekc] != '\u0000') break;
            c = this.charToken();
        }
        this.m_sval = StringCache.get(this.m_buf, pos);
        if (pos == 1 && this.m_buf[0] == ':') {
            return 58;
        }
        return -2;
    }

    protected void skipRecord() throws IOException {
        int ttype;
        while ((ttype = this.nextToken()) != -1 && ttype != 125) {
        }
    }

    public int getStartLineno() {
        return this.m_startLineno;
    }

    public void errorNS(String msg) {
        System.out.println("*** Error (" + this.filename() + ":" + this.lineno() + "): " + msg);
    }

    public void error(String msg) {
        System.out.println("*** Error (" + this.filename() + ":" + this.lineno() + "): " + msg + ". Found " + this.m_sval);
    }

    public void warning(String msg) {
        System.out.println(">>> Warning (" + this.filename() + ":" + this.lineno() + "): " + msg);
    }

    /*
     * Enabled aggressive block sorting
     */
    public int nextSection() throws IOException {
        String type;
        String graph;
        if (this.m_fatalError) {
            return 99;
        }
        if (this.m_token1 != null) {
            if (this.m_ttype3 != 58) {
                this.error("Expecting section header ':'");
                return -1;
            }
            graph = this.m_token1;
            type = this.m_token2;
            this.m_token1 = null;
            this.m_token2 = null;
        } else {
            int ttype = this.nextToken();
            switch (ttype) {
                case -1: {
                    return 99;
                }
                case -2: {
                    graph = this.m_sval;
                    if (this.nextToken() != -2) {
                        this.error("Expecting section type id");
                        return -1;
                    }
                    type = this.m_sval;
                    if (this.nextToken() == 58) break;
                    this.error("Expecting ':'");
                    return -1;
                }
                default: {
                    this.error("Expecting graph id");
                    return -1;
                }
            }
        }
        if (graph.equals(SCHEME_ID)) {
            if (type.equals(TUPLE_ID)) {
                return 0;
            }
            if (type.equals(ATTRIBUTE_ID)) {
                return 1;
            }
            this.error("Bad section type");
            return -1;
        }
        if (!graph.equals(FACT_ID)) {
            this.error("Bad section id");
            return -1;
        }
        if (type.equals(TUPLE_ID)) {
            return 2;
        }
        if (type.equals(ATTRIBUTE_ID)) {
            return 3;
        }
        this.error("Bad section type");
        return -1;
    }

    public boolean nextSchemaTriple() throws IOException {
        if (!this.m_fatalError) {
            this.m_startLineno = this.lineno();
            switch (this.nextToken()) {
                case -1: {
                    return false;
                }
                case -2: {
                    break;
                }
                default: {
                    this.error("Expecting word verb token");
                    this.m_fatalError = true;
                    return false;
                }
            }
            this.m_relations = 0;
            this.m_verb = this.m_sval;
            switch (this.nextToken()) {
                case -2: {
                    this.m_object = this.m_sval;
                    break;
                }
                case 40: {
                    this.m_relations |= 1;
                    if (this.nextToken() == -2) {
                        this.m_object = this.m_sval;
                        if (this.nextToken() == 41) break;
                    }
                }
                default: {
                    this.error("Expecting word object token");
                    this.m_fatalError = true;
                    return false;
                }
            }
            switch (this.nextToken()) {
                case 58: {
                    this.m_token1 = this.m_verb;
                    this.m_token2 = this.m_object;
                    this.m_ttype3 = 58;
                    return false;
                }
                case -2: {
                    this.m_subject = this.m_sval;
                    return true;
                }
                case 40: {
                    this.m_relations |= 2;
                    if (this.nextToken() != -2) break;
                    this.m_subject = this.m_sval;
                    if (this.nextToken() != 41) break;
                    return true;
                }
            }
            this.error("Expecting word subject token");
            this.m_fatalError = true;
            return true;
        }
        return false;
    }

    public boolean nextFactTriple() throws IOException {
        if (!this.m_fatalError) {
            this.m_startLineno = this.lineno();
            int ttype = this.nextToken();
            switch (ttype) {
                case -1: {
                    return false;
                }
                case -2: {
                    this.m_verb = this.m_sval;
                    if (this.nextToken() != -2) {
                        this.error("Expecting word token");
                        break;
                    }
                    this.m_object = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype == 58) {
                        this.m_token1 = this.m_verb;
                        this.m_token2 = this.m_object;
                        this.m_ttype3 = ttype;
                        return false;
                    }
                    if (ttype != -2) {
                        this.error("Error in tuple parse");
                        break;
                    }
                    this.m_subject = this.m_sval;
                    return true;
                }
                default: {
                    this.error("Expecting word token");
                }
            }
            this.m_fatalError = true;
        }
        return false;
    }

    private final int charAVI() throws IOException {
        int c = this.m_peekc;
        this.m_peekc = this.m_reader.read();
        return c;
    }

    public final void nextAVI(AttributeSettingNode target) throws IOException {
        int depth = 0;
        int pos = 0;
        int tokens = 0;
        int startbracket = -1;
        block37: while (true) {
            int c = this.charAVI();
            switch (c) {
                case -1: {
                    return;
                }
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 32: {
                    continue block37;
                }
                case 34: {
                    ++tokens;
                    int start = pos;
                    this.m_buf[pos++] = 34;
                    boolean escaped = false;
                    boolean simple = true;
                    block38: while (true) {
                        c = this.charAVI();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated \" in input");
                            }
                            case 92: {
                                escaped = !escaped;
                                this.m_buf[pos++] = 92;
                                simple = false;
                                continue block38;
                            }
                            case 34: {
                                if (!escaped) break block38;
                            }
                            case 39: {
                                simple = false;
                            }
                            default: {
                                if (c < m_ctype.length && m_ctype[c] == '\u0002') {
                                    simple = false;
                                }
                                this.m_buf[pos++] = (char)c;
                                escaped = false;
                                continue block38;
                            }
                        }
                        break;
                    }
                    if (!simple) {
                        this.m_buf[pos++] = 34;
                        break;
                    }
                    --pos;
                    while (++start <= pos) {
                        this.m_buf[start - 1] = this.m_buf[start];
                    }
                    break;
                }
                case 39: {
                    ++tokens;
                    int start = pos;
                    this.m_buf[pos++] = 39;
                    boolean escaped = false;
                    boolean simple = true;
                    block40: while (true) {
                        c = this.charAVI();
                        switch (c) {
                            case -1: {
                                System.out.println("Unterminated ' in input");
                                break block40;
                            }
                            case 92: {
                                escaped = !escaped;
                                this.m_buf[pos++] = 92;
                                simple = false;
                                continue block40;
                            }
                            case 39: {
                                if (!escaped) break block40;
                            }
                            case 34: {
                                simple = false;
                            }
                            default: {
                                if (c < m_ctype.length && m_ctype[c] == '\u0002') {
                                    simple = false;
                                }
                                this.m_buf[pos++] = (char)c;
                                escaped = false;
                                continue block40;
                            }
                        }
                        break;
                    }
                    if (!simple) {
                        this.m_buf[pos++] = 39;
                        break;
                    }
                    --pos;
                    while (++start <= pos) {
                        this.m_buf[start - 1] = this.m_buf[start];
                    }
                    break;
                }
                case 40: {
                    startbracket = pos;
                    this.m_buf[pos++] = 40;
                    if (depth != 0) {
                        tokens = 2;
                    }
                    ++depth;
                    continue block37;
                }
                case 41: {
                    int i;
                    if (depth <= 0) {
                        System.out.println("Bad nesting of () at " + this.lineno());
                        return;
                    }
                    switch (this.m_buf[pos - 1]) {
                        case '(': {
                            System.out.println("Empty nesting of () at " + this.lineno());
                            --pos;
                            break;
                        }
                        case ' ': {
                            --pos;
                        }
                        default: {
                            if (tokens != 1) {
                                this.m_buf[pos++] = 41;
                                break;
                            }
                            --pos;
                            for (i = startbracket; i < pos; ++i) {
                                this.m_buf[i] = this.m_buf[i + 1];
                            }
                        }
                    }
                    --depth;
                    break;
                }
                case 47: {
                    switch (this.m_peekc) {
                        case 47: {
                            block43: while (true) {
                                c = this.charAVI();
                                switch (c) {
                                    case 13: {
                                        if (this.m_peekc == 10) continue block43;
                                    }
                                    case -1: 
                                    case 10: {
                                        continue block37;
                                    }
                                }
                            }
                        }
                        case 42: {
                            block44: while (true) {
                                c = this.charAVI();
                                switch (c) {
                                    case 42: {
                                        if (this.m_peekc != 47) continue block44;
                                        c = this.charAVI();
                                    }
                                    case -1: {
                                        continue block37;
                                    }
                                }
                            }
                        }
                    }
                }
                default: {
                    int i;
                    if (c < m_ctype.length && m_ctype[c] == '\u0002') {
                        this.pushBack(c);
                        return;
                    }
                    ++tokens;
                    int start = pos;
                    boolean simple = true;
                    while (true) {
                        if (c == 92) {
                            simple = false;
                        }
                        this.m_buf[pos++] = (char)c;
                        if (this.m_peekc == -1 || c < m_ctype.length && m_ctype[this.m_peekc] != '\u0000') break;
                        c = this.charAVI();
                    }
                    if (simple) break;
                    for (i = pos; i >= start; --i) {
                        this.m_buf[i + 1] = this.m_buf[i];
                    }
                    this.m_buf[start] = 34;
                    this.m_buf[pos++] = 34;
                }
            }
            if (depth <= 0) break;
            this.m_buf[pos++] = 32;
        }
        if (tokens == 0) {
            return;
        }
        if (target != null) {
            target.setValue(StringCache.get(this.m_buf, pos));
        }
    }

    private void parseAttributes(AttributeNode target) throws IOException {
        AttributeSettingNode attribute = null;
        block4: while (true) {
            int ttype = this.nextToken();
            switch (ttype) {
                case 125: {
                    return;
                }
                case -2: {
                    if (target != null) {
                        attribute = new AttributeSettingNode(this.m_sval);
                        target.add(attribute);
                    }
                    if ((ttype = this.nextToken()) != 61) {
                        this.pushBack(ttype);
                        continue block4;
                    }
                    this.nextAVI(attribute);
                    continue block4;
                }
            }
            break;
        }
        this.error("Expecting attribute id for " + target);
    }

    private void processSchemeTuples() throws IOException {
        while (this.nextSchemaTriple()) {
            FactNode factnode;
            String verb = this.m_verb;
            String object = this.m_object;
            String subject = this.m_subject;
            if (subject.charAt(0) != '$') {
                subject = '$' + subject;
            }
            if (verb.equals(INHERIT_RELN)) {
                switch (this.m_relations) {
                    case 0: {
                        if (object.equals("$ENTITY")) {
                            this.errorNS("Improper use of $ENTITY with $INHERIT");
                            break;
                        }
                        if (subject.charAt(0) != '$') {
                            subject = '$' + subject;
                        }
                        factnode = new FactNode(verb, "$" + object, subject);
                        factnode.putInto(this.m_factbase);
                        break;
                    }
                    case 1: 
                    case 2: {
                        this.errorNS("Mismatched entity/relation with $INHERIT -- presuming both relations");
                    }
                    case 3: {
                        if (object.equals("$RELATION")) {
                            this.errorNS("Improper use of $RELATION with $INHERIT");
                            break;
                        }
                        if (!subject.equals("$RELATION")) {
                            subject = "$_" + subject;
                        }
                        factnode = new FactNode(verb, "$_" + object, subject);
                        factnode.putInto(this.m_factbase);
                    }
                }
                continue;
            }
            if (this.m_relations != 0) {
                this.errorNS("Cannot create relationships between relationships");
                continue;
            }
            factnode = new FactNode("$_" + verb, "$" + object, subject);
            factnode.putInto(this.m_factbase);
        }
    }

    private void processSchemeAttributes() throws IOException {
        ItemIdNode idnode = null;
        while (!this.m_fatalError) {
            this.m_startLineno = this.lineno();
            int ttype = this.nextToken();
            String msg = null;
            switch (ttype) {
                case -1: {
                    return;
                }
                case 40: {
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected ( <relation class name>";
                        break;
                    }
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 41) {
                        msg = "Expected ( " + token1 + "<)>";
                        break;
                    }
                    idnode = new ItemIdNode("$_" + token1);
                    ttype = this.nextToken();
                    if (ttype == 123) break;
                    msg = "Expected (...) <{>";
                    break;
                }
                case -2: {
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 123) {
                        if (ttype != -2) {
                            msg = "Expecting " + token1 + " <{>";
                            break;
                        }
                        String token2 = this.m_sval;
                        ttype = this.nextToken();
                        if (ttype != 58) {
                            msg = "Expecting section header or id <{>";
                            break;
                        }
                        this.m_token1 = token1;
                        this.m_token2 = token2;
                        this.m_ttype3 = ttype;
                        return;
                    }
                    idnode = new ItemIdNode("$" + token1);
                    break;
                }
                default: {
                    msg = "Expecting object id";
                }
            }
            if (msg != null) {
                this.errorNS(msg);
                this.skipRecord();
                continue;
            }
            AttributeNode attr = new AttributeNode(idnode);
            this.parseAttributes(attr);
            attr.putInto(this.m_factbase);
        }
    }

    private void processFactTuples() throws IOException {
        while (this.nextFactTriple()) {
            String subject = this.m_subject;
            if (this.m_verb.equals(INSTANCE_ID)) {
                subject = "$" + subject;
            }
            FactNode factnode = new FactNode(this.m_verb, this.m_object, subject);
            factnode.putInto(this.m_factbase);
        }
    }

    public void processFactAttributes() throws IOException {
        ItemIdNode idnode = null;
        while (!this.m_fatalError) {
            this.m_startLineno = this.lineno();
            int ttype = this.nextToken();
            String msg = null;
            switch (ttype) {
                case -1: {
                    return;
                }
                case 40: {
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected ( <class> src dst )";
                        break;
                    }
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected (" + token1 + " <src> dst)" + " not " + ttype;
                        break;
                    }
                    String token2 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != -2) {
                        msg = "Expected (" + token1 + " " + token2 + " <dst>)" + " not " + ttype;
                        break;
                    }
                    String token3 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 41) {
                        msg = "Expected (" + token1 + " " + token2 + " " + token3 + "<)>" + " not " + ttype;
                        break;
                    }
                    idnode = new ItemIdNode(token1, token2, token3);
                    ttype = this.nextToken();
                    if (ttype == 123) break;
                    msg = "Expected (...) <{> not " + ttype;
                    break;
                }
                case -2: {
                    String token2;
                    String token1 = this.m_sval;
                    ttype = this.nextToken();
                    if (ttype != 123) {
                        if (ttype != -2) {
                            msg = "Expecting " + token1 + " <{>";
                            break;
                        }
                        token2 = this.m_sval;
                        ttype = this.nextToken();
                        if (ttype != 58) {
                            msg = "Expecting section header or id <{>";
                            break;
                        }
                        this.m_token1 = token1;
                        this.m_token2 = token2;
                        this.m_ttype3 = ttype;
                        return;
                    }
                    idnode = new ItemIdNode(token1);
                    break;
                }
                default: {
                    msg = "Expecting object id";
                }
            }
            if (msg != null) {
                this.errorNS(msg);
                this.skipRecord();
                continue;
            }
            AttributeNode attr = new AttributeNode(idnode);
            this.parseAttributes(attr);
            attr.putInto(this.m_factbase);
        }
    }

    private void parseStream(LineNumberReader is) {
        try {
            block9: while (true) {
                switch (this.nextSection()) {
                    case 0: {
                        this.processSchemeTuples();
                        continue block9;
                    }
                    case 1: {
                        this.processSchemeAttributes();
                        continue block9;
                    }
                    case 2: {
                        this.processFactTuples();
                        continue block9;
                    }
                    case 3: {
                        this.processFactAttributes();
                        continue block9;
                    }
                    case 99: {
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            this.m_resString = e.getMessage();
            System.out.println("Parse error      : " + this.m_resString);
            System.out.println("Start Line number: " + this.getStartLineno());
            System.out.println("Last line read   : " + this.lineno());
            return;
        }
    }

    private InputStream decompress(InputStream is, String source, String subfile) {
        InputStream ret = is;
        int lth = source.length();
        if (lth > 4) {
            String ends = source.substring(lth - 4);
            if (ends.equalsIgnoreCase(".zip")) {
                ZipInputStream zipInputStream;
                try {
                    zipInputStream = new ZipInputStream(is);
                    while (true) {
                        ZipEntry zipEntry = zipInputStream.getNextEntry();
                        if (subfile != null && !subfile.equalsIgnoreCase(zipEntry.getName())) {
                            zipInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("Attempt to open " + source + (subfile == null ? "" : "#" + subfile) + " as zip file failed");
                    this.m_resString = e.getMessage();
                    zipInputStream = null;
                }
                return zipInputStream;
            }
            if (ends.equalsIgnoreCase(".jar")) {
                JarInputStream jarInputStream;
                try {
                    jarInputStream = new JarInputStream(is);
                    while (true) {
                        ZipEntry zipEntry = jarInputStream.getNextEntry();
                        if (subfile != null && !subfile.equalsIgnoreCase(zipEntry.getName())) {
                            jarInputStream.closeEntry();
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception e) {
                    System.out.println("Attempt to open " + source + (subfile == null ? "" : "#" + subfile) + " as jar file failed");
                    this.m_resString = e.getMessage();
                    jarInputStream = null;
                }
                return jarInputStream;
            }
            if (lth > 5 && (ends = source.substring(lth - 5)).equalsIgnoreCase(".gzip")) {
                GZIPInputStream gzipInputStream;
                try {
                    gzipInputStream = new GZIPInputStream(is);
                }
                catch (Exception e) {
                    System.out.println("Attempt to open " + source + " as gzip file failed");
                    this.m_resString = e.getMessage();
                    gzipInputStream = null;
                }
                return gzipInputStream;
            }
        }
        return is;
    }

    protected void parseFile(String taPath) {
        String entry = null;
        int lth = taPath.length();
        File file = null;
        if (lth > 0) {
            int i;
            char lc = taPath.charAt(lth - 1);
            if (lth > 2 && lc == ']' && (i = taPath.lastIndexOf(91)) > 0 && i < lth - 2) {
                entry = taPath.substring(i + 1, lth - 1);
                if (this.m_zipEntry == null) {
                    this.m_zipEntry = entry;
                }
                taPath = taPath.substring(0, i);
                lth = i;
                lc = taPath.charAt(lth - 1);
            }
            if (lc == File.separatorChar) {
                taPath = taPath.substring(0, lth - 1);
            }
        }
        try {
            LineNumberReader linenoReader;
            InputStream is = null;
            if (lth > 0 && (file = new File(taPath)) != null) {
                is = new FileInputStream(file);
                is = this.decompress(is, taPath, entry);
            }
            if (is == null) {
                if (this.m_resString == null) {
                    this.m_resString = "No input stream specified";
                }
                return;
            }
            InputStreamReader reader = new InputStreamReader(is);
            this.m_reader = linenoReader = new LineNumberReader(reader);
            linenoReader.setLineNumber(1);
            this.parseStream(linenoReader);
            linenoReader.close();
            linenoReader = null;
        }
        catch (Exception e) {
            this.m_resString = e.getMessage();
        }
    }

    public TAFileReader() {
        m_ctype = new char[256];
        TAFileReader.m_ctype[32] = 2;
        TAFileReader.m_ctype[12] = 2;
        TAFileReader.m_ctype[9] = 2;
        TAFileReader.m_ctype[13] = 2;
        TAFileReader.m_ctype[10] = 2;
        TAFileReader.m_ctype[61] = 2;
        TAFileReader.m_ctype[123] = 2;
        TAFileReader.m_ctype[125] = 2;
        TAFileReader.m_ctype[40] = 2;
        TAFileReader.m_ctype[41] = 2;
        TAFileReader.m_ctype[34] = 3;
        TAFileReader.m_ctype[39] = 3;
    }

    @Override
    public Factbase read(String taFile) {
        this.m_factbase = new Factbase(taFile);
        this.m_resString = null;
        this.m_zipEntry = null;
        this.m_filename = taFile;
        this.parseFile(taFile);
        if (this.m_resString != null) {
            System.out.println(this.m_resString);
        }
        return this.m_factbase;
    }

    static {
        m_strict_TA = false;
    }
}

