/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.CompositeID;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.UtilityOperation;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.util.Enumeration;

public class DeleteSet
extends Function {
    public DeleteSet() {
        this.name = "delset";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 1: {
                NodeSet set = (NodeSet)vals[0].objectValue();
                NodeSet del = CompositeID.getEnclosingIDs(set);
                del = AlgebraOperation.union(del, set);
                Scope scp = env.peepScope();
                Enumeration<Variable> enm = scp.allVariables();
                while (enm.hasMoreElements()) {
                    Variable var = enm.nextElement();
                    if (var.getType() != EdgeSet.class) continue;
                    EdgeSet eSet = (EdgeSet)var.getValue().objectValue();
                    eSet = UtilityOperation.delset(eSet, del);
                    eSet.setName(var.getName());
                    var.setValue(new Value(eSet));
                }
                return Value.VOID;
            }
            case 2: {
                EdgeSet data = (EdgeSet)vals[0].objectValue();
                NodeSet set = (NodeSet)vals[1].objectValue();
                NodeSet del = CompositeID.getEnclosingIDs(set);
                del = AlgebraOperation.union(del, set);
                EdgeSet result = UtilityOperation.delset(data, del);
                return new Value(result);
            }
        }
        return this.illegalUsage();
    }

    @Override
    public String usage() {
        return "void " + this.name + "([EdgeSet edgeset,] NodeSet del)";
    }
}

