/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class Entropy
extends Function {
    public Entropy() {
        this.name = "entropy";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 1: {
                double result = 0.0;
                EdgeSet eSet = vals[0].edgeSetValue();
                if (eSet.size() == 0) {
                    result = 0.0;
                } else {
                    TupleList tList = eSet.getTupleList();
                    for (int i = 0; i < tList.size(); ++i) {
                        Tuple t = tList.get(i);
                        try {
                            double p = Double.parseDouble(IDManager.get(t.getRng()));
                            if (0.0 < p && p <= 1.0) {
                                result -= p * Math.log(p) / Math.log(2.0);
                            }
                            if (!(p < 0.0) && !(p > 1.0)) continue;
                            throw new InvocationException("illegal probability " + p);
                        }
                        catch (Exception e) {
                            throw new InvocationException(e.getMessage());
                        }
                    }
                }
                return new Value(result);
            }
        }
        return this.illegalUsage();
    }

    @Override
    public String usage() {
        return "double " + this.name + "(EdgeSet tuples)";
    }
}

