/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.FunctionLib;
import ca.uwaterloo.cs.jgrok.lib.RootFunctionLib;
import java.util.Enumeration;
import java.util.Hashtable;

public class FunctionLibManager {
    public static final String JGrokLibName = "JGrok";
    private static final FunctionLib rootLib = new RootFunctionLib("JGrok");
    private static final Hashtable<String, FunctionLib> libEntries = new Hashtable();

    public static FunctionLib getRootLib() {
        return rootLib;
    }

    public static FunctionLib findLib(String libName) {
        if (libName == null) {
            return rootLib;
        }
        return libEntries.get(libName);
    }

    public static FunctionLib getLib(String libName) {
        FunctionLib lib = FunctionLibManager.findLib(libName);
        if (lib == null) {
            lib = new FunctionLib(libName);
            libEntries.put(libName, lib);
        }
        return lib;
    }

    public static void register(String libName, Function f) {
        FunctionLib lib = libName == null ? FunctionLibManager.getRootLib() : FunctionLibManager.getLib(libName);
        lib.register(f);
    }

    public static void getUse(EdgeSet edgeSet) {
        FunctionLib library;
        int size = libEntries.size();
        FunctionLib[] libraries = new FunctionLib[size];
        Enumeration<FunctionLib> en = libEntries.elements();
        int i = 0;
        while (en.hasMoreElements()) {
            FunctionLib library1;
            library = en.nextElement();
            String name1 = library.getName();
            for (int j = i; j > 0 && name1.compareToIgnoreCase((library1 = libraries[j - 1]).getName()) < 0; --j) {
                libraries[j] = library1;
            }
            libraries[j] = library;
            ++i;
        }
        for (i = 0; i < size; ++i) {
            library = libraries[i];
            library.getUse(edgeSet);
        }
    }

    static {
        libEntries.put(rootLib.getName(), rootLib);
    }
}

