/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.util.regex.PatternSyntaxException;

public class Grep
extends Function {
    public Grep() {
        this.name = "grep";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 2: {
                NodeSet result = new NodeSet();
                NodeSet set = vals[0].nodeSetValue();
                String regex = vals[1].stringValue();
                int len = regex.length();
                if (!(regex.charAt(0) == '^' || len > 1 && regex.substring(0, 2).equals(".*"))) {
                    regex = ".*" + regex;
                }
                if (!(regex.charAt((len = regex.length()) - 1) == '$' || len > 1 && regex.substring(len - 2, len).equals(".*"))) {
                    regex = regex + ".*";
                }
                Node[] nodes = set.getAllNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    Node node = nodes[i];
                    String s = node.get();
                    try {
                        if (s.matches(regex)) {
                            result.add(node.getID());
                            continue;
                        }
                        if (s.indexOf(regex) <= 0) continue;
                        result.add(node.getID());
                        continue;
                    }
                    catch (PatternSyntaxException e) {
                        throw new InvocationException(e.getMessage());
                    }
                }
                return new Value(result);
            }
        }
        return this.illegalUsage();
    }

    @Override
    public String usage() {
        return "NodeSet " + this.name + "(NodeSet nodes, String regex)";
    }
}

