/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.Tree;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class Level
extends Function {
    public Level() {
        this.name = "level";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        Tree tree;
        int[] roots;
        NodeSet nodes = null;
        EdgeSet contain = null;
        switch (vals.length) {
            case 2: {
                contain = vals[1].edgeSetValue();
            }
            case 1: {
                nodes = vals[0].nodeSetValue();
                break;
            }
            default: {
                return this.illegalUsage();
            }
        }
        if (contain == null) {
            try {
                Variable var = env.lookup("contain");
                if (var.getType() != EdgeSet.class) {
                    throw new InvocationException("contain is not relation");
                }
                contain = (EdgeSet)var.getValue().objectValue();
            }
            catch (Exception e) {
                throw new InvocationException("contain not found");
            }
        }
        if ((roots = (tree = new Tree(contain)).getRoots()).length > 1) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < roots.length; ++i) {
                buffer.append("\n\t" + IDManager.get(roots[i]));
            }
            throw new InvocationException("multiple roots found:" + buffer.toString());
        }
        if (roots.length == 1) {
            EdgeSet l = tree.getLevelRelation();
            if (nodes == null) {
                return new Value(l);
            }
            return new Value(AlgebraOperation.composition(nodes, l));
        }
        throw new InvocationException("root not found");
    }

    @Override
    public String usage() {
        return "EdgeSet " + this.name + "([NodeSet nodes [, EdgeSet contain]])";
    }
}

