/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.fb.UtilityOperation;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class OutDegree
extends Function {
    public OutDegree() {
        this.name = "outindegree";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        NodeSet nSet;
        EdgeSet eSet;
        switch (vals.length) {
            case 1: {
                eSet = (EdgeSet)vals[0].objectValue();
                nSet = AlgebraOperation.domainOf(eSet);
                break;
            }
            case 2: {
                Value value0 = vals[0];
                Value value1 = vals[1];
                if (value1.isPrimitive()) {
                    TupleSet tSet = (TupleSet)value0.objectValue();
                    int column = value1.intValue();
                    EdgeSet result = UtilityOperation.outdegree(tSet, column);
                    return new Value(result);
                }
                eSet = (EdgeSet)value1.objectValue();
                nSet = (NodeSet)value0.objectValue();
                break;
            }
            default: {
                return this.illegalUsage();
            }
        }
        EdgeSet result = AlgebraOperation.composition(nSet, eSet);
        result = UtilityOperation.outdegree(result);
        return new Value(result);
    }

    @Override
    public String usage() {
        return "EdgeSet " + this.name + "([NodeSet nodes,] EdgeSet edges)/(TupleSet relation, int column)";
    }
}

