/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.Path;
import ca.uwaterloo.cs.jgrok.fb.PathClosure;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.fb.UtilityOperation;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class Paths
extends Function {
    public Paths() {
        this.name = "paths";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        Path[] paths;
        switch (vals.length) {
            case 3: {
                String source = vals[0].stringValue();
                String target = vals[1].stringValue();
                EdgeSet eSet = vals[2].edgeSetValue();
                eSet = UtilityOperation.reach(NodeSet.singleton(source), NodeSet.singleton(target), eSet);
                PathClosure pClosure = new PathClosure(eSet);
                paths = pClosure.getPaths(source, target);
                break;
            }
            case 2: {
                paths = new Path[]{};
                break;
            }
            case 1: {
                EdgeSet eSet = vals[0].edgeSetValue();
                PathClosure pClosure = new PathClosure(eSet);
                paths = pClosure.getPaths();
                break;
            }
            default: {
                return this.illegalUsage();
            }
        }
        TupleSet pSet = new TupleSet(paths.length);
        for (int i = 0; i < paths.length; ++i) {
            pSet.add(paths[i].getTuple());
        }
        return new Value(pSet);
    }

    @Override
    public String usage() {
        return "EdgeSet " + this.name + "([[String sourceNode,] String targetNode,] EdgeSet edgeSet)";
    }
}

