/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.Factbase;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.LookupException;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.io.FactbaseReader;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.io.FileNotFoundException;
import java.util.Enumeration;

public abstract class Reader
extends Function {
    protected Value load(Env env, FactbaseReader fbReader, String fileName) throws InvocationException {
        Factbase fb;
        try {
            fb = fbReader.read(fileName);
        }
        catch (FileNotFoundException e) {
            throw new InvocationException(fileName + " not found");
        }
        Enumeration<TupleSet> enm = fb.allSets();
        Scope scp = env.peepScope();
        while (enm.hasMoreElements()) {
            Variable var;
            TupleSet set = enm.nextElement();
            try {
                var = scp.lookup(set.getName());
                if (set instanceof EdgeSet && var.getType() == EdgeSet.class) {
                    EdgeSet eSet1 = (EdgeSet)var.getValue().objectValue();
                    EdgeSet eSet2 = (EdgeSet)set;
                    EdgeSet result = AlgebraOperation.union(eSet1, eSet2);
                    var.setValue(new Value(result));
                    result.setName(var.getName());
                    continue;
                }
                var.setValue(new Value(set));
            }
            catch (LookupException e) {
                var = new Variable(scp, set.getName(), new Value(set));
                scp.addVariable(var);
            }
        }
        return Value.VOID;
    }

    @Override
    public String usage() {
        return "void " + this.name + "(String dataFile)";
    }
}

