/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.util.ArrayList;

public class Replace
extends Function {
    private boolean flagReplaceAll = false;

    public Replace() {
        this.name = "replace";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        if (vals.length != 2) {
            return this.illegalUsage();
        }
        this.flagReplaceAll = false;
        if (vals[0].isPrimitive()) {
            return this.stringReplace(vals);
        }
        TupleSet input = vals[0].tupleSetValue();
        if (input.hasName()) {
            input = (TupleSet)input.clone();
        }
        TupleSet result = input.newSet();
        String exp = vals[1].stringValue().trim();
        String[] parts = this.tokenize(exp);
        int col = this.parseColumn(parts[0]);
        String regxExp = parts[1];
        String replExp = parts[2];
        ArrayList<Object> replList = this.parse(replExp);
        int replSize = replList.size();
        TupleList data = input.getTupleList();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.size(); ++i) {
            Tuple tuple = data.get(i);
            if (col >= tuple.size()) continue;
            buf.delete(0, buf.length());
            for (int j = 0; j < replSize; ++j) {
                Object o = replList.get(j);
                if (o instanceof String) {
                    buf.append(o);
                    continue;
                }
                int v = (Integer)o;
                if (v < tuple.size()) {
                    buf.append(IDManager.get(tuple.get(v)));
                    continue;
                }
                throw new InvocationException("index " + v + " out of bounds " + tuple.size());
            }
            try {
                String repl = buf.toString();
                String sval = this.flagReplaceAll ? IDManager.get(tuple.get(col)).replaceAll(regxExp, repl) : IDManager.get(tuple.get(col)).replaceFirst(regxExp, repl);
                tuple.set(col, IDManager.getID(sval));
                result.add(tuple);
                continue;
            }
            catch (Exception e) {
                throw new InvocationException(e.getMessage());
            }
        }
        return new Value(result);
    }

    private String[] tokenize(String exp) throws InvocationException {
        String flag;
        int i;
        int len = exp.length();
        String[] result = new String[3];
        StringBuffer buf = new StringBuffer();
        int prev = 38;
        int j = 0;
        for (i = 0; i < len && j < 3; ++i) {
            char curr = exp.charAt(i);
            if (curr == '/') {
                if (prev == 92) {
                    prev = curr;
                    buf.append('/');
                    continue;
                }
                result[j] = buf.toString();
                buf.delete(0, buf.length());
                ++j;
                continue;
            }
            prev = curr;
            buf.append(curr);
        }
        if (j == 2 && buf.length() > 0) {
            result[j] = buf.toString();
            ++j;
        }
        if ((flag = exp.substring(i).trim()).length() > 0 && flag.charAt(0) == 'g') {
            this.flagReplaceAll = true;
        }
        if (j == 3) {
            return result;
        }
        throw new InvocationException("illegal replace expression: " + exp);
    }

    private int parseColumn(String colExp) throws InvocationException {
        String trim = colExp.trim();
        if (trim.length() == 0) {
            throw new InvocationException(trim + "column not specified");
        }
        if (trim.charAt(0) == '&') {
            trim = trim.substring(1);
            trim = trim.trim();
        }
        if (trim.length() == 0) {
            throw new InvocationException(trim + "column not specified");
        }
        for (int pos = 0; pos < trim.length(); ++pos) {
            if (this.isDigit(trim.charAt(pos))) {
                continue;
            }
            throw new InvocationException(trim + " is not int");
        }
        try {
            int col = Integer.parseInt(trim);
            return col;
        }
        catch (NumberFormatException e) {
            throw new InvocationException(trim + " is not int");
        }
    }

    private ArrayList<Object> parse(String exp) throws InvocationException {
        String rest = exp;
        StringBuffer buf = new StringBuffer();
        ArrayList<Object> list = new ArrayList<Object>(2);
        int pos = rest.indexOf("&");
        int len = rest.length();
        while (pos >= 0) {
            char c;
            list.add(rest.substring(0, pos));
            rest = rest.substring(++pos, len);
            len = rest.length();
            buf.delete(0, buf.length());
            for (int i = 0; i < len && this.isDigit(c = rest.charAt(i)); ++i) {
                buf.append(c);
            }
            if (buf.length() > 0) {
                try {
                    Integer I = new Integer(buf.toString());
                    list.add(I);
                }
                catch (NumberFormatException e) {
                    throw new InvocationException(buf + " is not int");
                }
            }
            rest = rest.substring(buf.length(), len);
            len = rest.length();
            pos = rest.indexOf("&");
        }
        if (rest.length() > 0) {
            list.add(rest);
        }
        return list;
    }

    private boolean isDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private Value stringReplace(Value[] vals) throws InvocationException {
        String str = vals[0].toString();
        String exp = vals[1].toString().trim();
        String[] parts = this.tokenize2(exp);
        String regxExp = parts[0];
        String replExp = parts[1];
        try {
            if (this.flagReplaceAll) {
                return new Value(str.replaceAll(regxExp, replExp));
            }
            return new Value(str.replaceFirst(regxExp, replExp));
        }
        catch (Exception e) {
            throw new InvocationException(e.getMessage());
        }
    }

    private String[] tokenize2(String exp) throws InvocationException {
        String flag;
        int i;
        int len = exp.length();
        String[] result = new String[2];
        StringBuffer buf = new StringBuffer();
        int prev = 47;
        int j = 0;
        for (i = 0; i < len && j < 2; ++i) {
            char curr = exp.charAt(i);
            if (curr == '/') {
                if (i == 0) continue;
                if (prev == 92) {
                    prev = curr;
                    buf.append('/');
                    continue;
                }
                result[j] = buf.toString();
                buf.delete(0, buf.length());
                ++j;
                continue;
            }
            prev = curr;
            buf.append(curr);
        }
        if (j == 1 && buf.length() > 0) {
            result[j] = buf.toString();
            ++j;
        }
        if ((flag = exp.substring(i).trim()).length() > 0 && flag.charAt(0) == 'g') {
            this.flagReplaceAll = true;
        }
        if (j == 2) {
            return result;
        }
        throw new InvocationException("illegal replace expression: " + exp);
    }

    @Override
    public String usage() {
        return "String " + this.name + "(String source, String regex)/TupleSet " + this.name + "(TupleSet set, String regex)";
    }
}

