/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.Interp;
import ca.uwaterloo.cs.jgrok.interp.ScriptUnitNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.io.File;
import java.io.FileNotFoundException;

public class ScriptParser
extends Function {
    public ScriptParser() {
        this.name = "parse";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 2: {
                String filePath = vals[0].stringValue();
                String aliasName = vals[1].stringValue();
                ScriptUnitNode master = env.traceScriptUnit();
                try {
                    Interp interp;
                    try {
                        File file = new File(filePath);
                        interp = Interp.reinit(file);
                    }
                    catch (FileNotFoundException e) {
                        File file = filePath.charAt(0) == '~' ? new File(System.getProperty("user.home"), filePath.substring(1)) : new File(master.getFileParent(), filePath);
                        interp = Interp.reinit(file);
                    }
                    ScriptUnitNode unit = interp.parse();
                    unit.setAliasName(aliasName);
                    master.addSourceUnit(unit);
                }
                catch (FileNotFoundException e) {
                    throw new InvocationException("no such a file: " + filePath);
                }
                return Value.VOID;
            }
        }
        return this.illegalUsage();
    }

    @Override
    public String usage() {
        return "void " + this.name + "(String scriptFile, String alias)";
    }
}

