/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.EvaluationException;
import ca.uwaterloo.cs.jgrok.interp.Interp;
import ca.uwaterloo.cs.jgrok.interp.ScriptUnitNode;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.io.File;
import java.io.FileNotFoundException;

public class ScriptSource
extends Function {
    private Env env;

    public ScriptSource() {
        this.name = "source";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        if (vals.length == 0) {
            return this.illegalUsage();
        }
        String scriptFile = vals[0].stringValue();
        this.env = env;
        Value[] args = new Value[vals.length - 1];
        for (int i = 0; i < args.length; ++i) {
            args[i] = vals[i + 1];
        }
        ScriptUnitNode unit = this.find(scriptFile);
        if (unit == null) {
            unit = this.parse(scriptFile);
        }
        return this.evaluate(unit, args);
    }

    private ScriptUnitNode find(String aliasName) throws InvocationException {
        ScriptUnitNode master = this.env.traceScriptUnit();
        ScriptUnitNode[] slaves = master.getSourceUnits(aliasName);
        if (slaves.length == 0) {
            return null;
        }
        if (slaves.length == 1) {
            return slaves[0];
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("ambiguous aliases: ");
        for (int i = 0; i < slaves.length; ++i) {
            buffer.append("\n");
            buffer.append("\t");
            buffer.append(slaves[i].getAliasName());
            buffer.append("\t");
            buffer.append(slaves[i].getFullName());
        }
        throw new InvocationException(buffer.toString());
    }

    private ScriptUnitNode parse(String filePath) throws InvocationException {
        File file = new File(filePath);
        String fileName = file.getName();
        int dotInd = fileName.indexOf(46);
        String aliasName = dotInd > 0 ? fileName.substring(0, dotInd) : fileName;
        ScriptUnitNode master = this.env.traceScriptUnit();
        try {
            Interp interp;
            try {
                interp = Interp.reinit(file);
            }
            catch (FileNotFoundException e) {
                file = filePath.charAt(0) == '~' ? new File(System.getProperty("user.home"), filePath.substring(1)) : new File(master.getFileParent(), filePath);
                interp = Interp.reinit(file);
            }
            ScriptUnitNode slave = interp.parse();
            if (slave != null) {
                slave.setAliasName(aliasName);
                master.addSourceUnit(slave);
                return slave;
            }
            throw new InvocationException("parse error encountered in " + filePath);
        }
        catch (FileNotFoundException ex) {
            throw new InvocationException("no such a file: " + filePath);
        }
    }

    private Value evaluate(ScriptUnitNode unit, Value[] args) throws InvocationException {
        Value val;
        Variable var = new Variable(unit, "$#", new Value(args.length));
        unit.addVariable(var);
        var = new Variable(unit, "$0", new Value(unit.getFileName()));
        unit.addVariable(var);
        for (int i = 0; i < args.length; ++i) {
            var = new Variable(unit, "$" + (i + 1), args[i]);
            unit.addVariable(var);
        }
        try {
            this.env.pushScope(unit);
            val = unit.evaluate(this.env);
        }
        catch (EvaluationException e) {
            throw new InvocationException(e.getMessage());
        }
        finally {
            unit.clear();
            this.env.popScope();
        }
        return val;
    }

    @Override
    public String usage() {
        return "void " + this.name + "(scriptFile [, argument]*)";
    }
}

