/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.ShowDB;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.util.ArrayList;
import java.util.Enumeration;

public class Show
extends Function {
    public Show() {
        this.name = "show";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 1: {
                Value value0 = vals[0];
                Scope scp = env.peepScope();
                if (!vals[0].isNodeSet()) {
                    String sid = value0.stringValue();
                    Show.print(env, IDManager.getID(sid), scp);
                } else {
                    String sid;
                    int i;
                    NodeSet nodeset = value0.nodeSetValue();
                    Node[] nodes = nodeset.getAllNodes();
                    for (i = 0; i < nodes.length - 1; ++i) {
                        sid = nodes[i].get();
                        Show.print(env, IDManager.getID(sid), scp);
                        env.out.println();
                    }
                    if (nodes.length > 0) {
                        sid = nodes[i].get();
                        Show.print(env, IDManager.getID(sid), scp);
                    }
                }
                return Value.VOID;
            }
        }
        return this.illegalUsage();
    }

    static void print(Env env, int node, Scope scp) {
        EdgeSet eSet;
        String attVal;
        ArrayList<EdgeSet> attrSets = new ArrayList<EdgeSet>();
        ArrayList<EdgeSet> edgeSets = new ArrayList<EdgeSet>();
        StringBuffer buffer = new StringBuffer();
        EdgeSet contain = null;
        EdgeSet instance = null;
        EdgeSet nameAttr = null;
        Enumeration<Variable> enm = scp.allVariables();
        while (enm.hasMoreElements()) {
            Variable var = enm.nextElement();
            if (var.getType() != EdgeSet.class) continue;
            String varName = var.getName();
            if (varName.equals("@name")) {
                nameAttr = (EdgeSet)var.getValue().objectValue();
                continue;
            }
            if (varName.charAt(0) == '@') {
                attrSets.add((EdgeSet)var.getValue().objectValue());
                continue;
            }
            if (varName.equals("$INSTANCE")) {
                instance = (EdgeSet)var.getValue().objectValue();
                continue;
            }
            if (varName.equals("contain")) {
                contain = (EdgeSet)var.getValue().objectValue();
                continue;
            }
            edgeSets.add((EdgeSet)var.getValue().objectValue());
        }
        String name = ShowDB.getAtt(node, nameAttr);
        if (name == null) {
            buffer.append(IDManager.get(node));
            buffer.append(" : ");
            attVal = ShowDB.getAtt(node, instance);
            if (attVal != null) {
                buffer.append(attVal);
                buffer.append(' ');
            }
        } else {
            buffer.append(name);
            buffer.append(" : ");
            attVal = ShowDB.getAtt(node, instance);
            if (attVal != null) {
                buffer.append(attVal);
                buffer.append(' ');
            }
            buffer.append("@ ");
            buffer.append(IDManager.get(node));
            buffer.append(' ');
        }
        buffer.append("{ ");
        int sofar = buffer.length();
        for (int i = 0; i < attrSets.size(); ++i) {
            eSet = (EdgeSet)attrSets.get(i);
            attVal = ShowDB.getAtt(node, eSet);
            if (attVal == null) continue;
            buffer.append(eSet.getName().substring(1));
            buffer.append('=');
            buffer.append(attVal);
            buffer.append(' ');
        }
        if (sofar != buffer.length()) {
            buffer.append('}');
        } else {
            buffer.delete(sofar - 3, sofar);
        }
        env.out.println(buffer.toString());
        NodeSet singleton = NodeSet.singleton(node);
        if (contain != null) {
            NodeSet data = AlgebraOperation.project(contain, singleton);
            Node[] nodes = data.getAllNodes();
            for (int i = 0; i < nodes.length; ++i) {
                env.out.println("   ( contain <- " + Show.compose(nodes[i].get(), nameAttr) + " )");
            }
        }
        for (int i = 0; i < edgeSets.size(); ++i) {
            eSet = (EdgeSet)edgeSets.get(i);
            ArrayList<String> info = ShowDB.getRels(node, eSet, nameAttr);
            for (int j = 0; j < info.size(); ++j) {
                env.out.println("   " + info.get(j));
            }
        }
        if (contain != null) {
            NodeSet data = AlgebraOperation.project(singleton, contain);
            Node[] nodes = data.getAllNodes();
            for (int i = 0; i < nodes.length; ++i) {
                env.out.println("|  " + Show.compose(nodes[i].get(), nameAttr));
            }
        }
    }

    private static String compose(String sid, EdgeSet nameAttr) {
        String name = ShowDB.getAtt(IDManager.getID(sid), nameAttr);
        if (name != null) {
            return name + " @ " + sid;
        }
        return sid;
    }

    @Override
    public String usage() {
        return "void " + this.name + "(String/Nodeset set)";
    }
}

