/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.ShowDB;
import ca.uwaterloo.cs.jgrok.fb.Tree;
import ca.uwaterloo.cs.jgrok.fb.Tree2;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class ShowEdge
extends Function {
    private Env env;
    private StringBuffer indent = new StringBuffer();
    public static final int METHOD_UNKNOWN = 0;
    public static final int METHOD_ROOT_NODE = 1;
    public static final int METHOD_ROOT_NODE_LEVEL = 2;
    public static final int METHOD_SOURCE_DESTINATION = 3;
    public static final int METHOD_SOURCE_DESTINATION_LEVEL = 4;

    public ShowEdge() {
        this.name = "showedge";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        Tree2 tree2;
        int whichMethod = 0;
        String srcNode = null;
        String trgNode = null;
        EdgeSet edgeSet = null;
        int level = 0;
        this.env = env;
        if (vals.length > 0) {
            srcNode = vals[0].toString();
            switch (vals.length) {
                case 2: {
                    whichMethod = 1;
                    edgeSet = (EdgeSet)vals[1].objectValue();
                    break;
                }
                case 3: {
                    if (vals[1].isPrimitive()) {
                        whichMethod = 3;
                        trgNode = vals[1].toString();
                        edgeSet = (EdgeSet)vals[2].objectValue();
                        break;
                    }
                    whichMethod = 2;
                    edgeSet = (EdgeSet)vals[1].objectValue();
                    level = vals[2].intValue();
                    if (level >= 0) break;
                    throw new InvocationException("illegal showedge level: " + level);
                }
                case 4: {
                    whichMethod = 4;
                    trgNode = vals[1].toString();
                    edgeSet = (EdgeSet)vals[2].objectValue();
                    level = vals[3].intValue();
                }
            }
            if (level < 0) {
                throw new InvocationException("illegal showedge level: " + level);
            }
        }
        if (whichMethod == 0) {
            return this.illegalUsage();
        }
        try {
            EdgeSet contain = this.findContain();
            tree2 = new Tree2(contain);
        }
        catch (InvocationException e) {
            env.out.println("trivial showedge, not implemented");
            return Value.VOID;
        }
        switch (whichMethod) {
            case 1: {
                int srcId = IDManager.getID(srcNode);
                Tree edgeTree = tree2.getEdgeTree(srcId, edgeSet);
                EdgeSet multiplicity = new EdgeSet();
                this.calculateMultiplicity(srcId, edgeTree, multiplicity, true);
                this.printNode(srcId, edgeTree, edgeSet.getName(), multiplicity);
                break;
            }
            case 2: {
                int srcId = IDManager.getID(srcNode);
                Tree edgeTree = tree2.getEdgeTree(srcId, edgeSet);
                EdgeSet multiplicity = new EdgeSet();
                this.calculateMultiplicity(srcId, edgeTree, multiplicity, true);
                this.printNode(srcId, edgeTree, edgeSet.getName(), multiplicity, 0, level);
                break;
            }
            case 3: {
                int srcID = IDManager.getID(srcNode);
                int trgID = IDManager.getID(trgNode);
                Tree edgeTree = tree2.getEdgeTree(srcID, trgID, edgeSet);
                int edgeRoot = edgeTree.getRoots()[0];
                EdgeSet multiplicity = new EdgeSet();
                this.calculateMultiplicity(edgeRoot, edgeTree, multiplicity, true);
                this.printEdge(edgeRoot, edgeTree, true, edgeSet.getName(), multiplicity);
                break;
            }
            case 4: {
                int srcID = IDManager.getID(srcNode);
                int trgID = IDManager.getID(trgNode);
                Tree edgeTree = tree2.getEdgeTree(srcID, trgID, edgeSet);
                int edgeRoot = edgeTree.getRoots()[0];
                EdgeSet multiplicity = new EdgeSet();
                this.calculateMultiplicity(edgeRoot, edgeTree, multiplicity, true);
                this.printEdge(edgeRoot, edgeTree, true, edgeSet.getName(), multiplicity, 0, level);
            }
        }
        return Value.VOID;
    }

    private EdgeSet findContain() throws InvocationException {
        try {
            Variable var = this.env.peepScope().lookup("contain");
            if (var.getType() != EdgeSet.class) {
                throw new InvocationException("contain is not relation");
            }
            return (EdgeSet)var.getValue().objectValue();
        }
        catch (Exception e) {
            throw new InvocationException("contain not found");
        }
    }

    private int calculateMultiplicity(int node, Tree tree, EdgeSet eSet, boolean isRoot) {
        int multiplicity = 0;
        int[] children = tree.getChildren(node);
        if (children.length == 0) {
            multiplicity = isRoot ? 0 : 1;
        } else {
            for (int i = 0; i < children.length; ++i) {
                multiplicity += this.calculateMultiplicity(children[i], tree, eSet, false);
            }
        }
        eSet.add(node, IDManager.getID(multiplicity + ""));
        return multiplicity;
    }

    private void printNode(int node, Tree tree, String relName, EdgeSet multiplicity) {
        String num = ShowDB.getAtt(node, multiplicity);
        this.env.out.println(this.indent.toString() + num + " : " + IDManager.get(node));
        int[] children = tree.getChildren(node);
        if (children.length > 0) {
            this.incrIndent();
            for (int i = 0; i < children.length; ++i) {
                this.printEdge(children[i], tree, false, relName, multiplicity);
            }
            this.decrIndent();
        }
    }

    private void printNode(int node, Tree tree, String relName, EdgeSet multiplicity, int curLevel, int endLevel) {
        String num = ShowDB.getAtt(node, multiplicity);
        this.env.out.println(this.indent.toString() + num + " : " + IDManager.get(node));
        if (curLevel == endLevel) {
            return;
        }
        int[] children = tree.getChildren(node);
        if (children.length > 0) {
            this.incrIndent();
            for (int i = 0; i < children.length; ++i) {
                this.printEdge(children[i], tree, false, relName, multiplicity, curLevel + 1, endLevel);
            }
            this.decrIndent();
        }
    }

    private void printEdge(int edge, Tree tree, boolean isRoot, String relName, EdgeSet multiplicity) {
        String s = isRoot ? "=>" : IDManager.get(edge);
        String num = ShowDB.getAtt(edge, multiplicity);
        int[] children = tree.getChildren(edge);
        if (children.length == 0) {
            s = s.substring(1, s.length() - 1);
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.indent.toString());
            buffer.append(' ');
            buffer.append("-> (");
            buffer.append(relName);
            buffer.append(' ');
            buffer.append(s);
            buffer.append(')');
            this.env.out.println(buffer.toString());
        } else {
            if (isRoot) {
                this.env.out.println(this.indent.toString() + num + " : " + s);
            } else {
                int[] parse = IDManager.parse(edge);
                if (parse.length == 1) {
                    this.env.out.println(this.indent.toString() + num + " : " + s);
                } else {
                    this.env.out.println(this.indent.toString() + num + " : => " + s);
                }
            }
            this.incrIndent();
            for (int i = 0; i < children.length; ++i) {
                this.printEdge(children[i], tree, false, relName, multiplicity);
            }
            this.decrIndent();
        }
    }

    private void printEdge(int edge, Tree tree, boolean isRoot, String relName, EdgeSet multiplicity, int curLevel, int endLevel) {
        String s = isRoot ? "=>" : IDManager.get(edge);
        String num = ShowDB.getAtt(edge, multiplicity);
        int[] children = tree.getChildren(edge);
        if (children.length == 0) {
            s = s.substring(1, s.length() - 1);
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.indent.toString());
            buffer.append(' ');
            buffer.append("-> (");
            buffer.append(relName);
            buffer.append(' ');
            buffer.append(s);
            buffer.append(')');
            this.env.out.println(buffer.toString());
        } else {
            if (isRoot) {
                this.env.out.println(this.indent.toString() + num + " : " + s);
            } else {
                int[] parse = IDManager.parse(edge);
                if (parse.length == 1) {
                    this.env.out.println(this.indent.toString() + num + " : " + s);
                } else {
                    this.env.out.println(this.indent.toString() + num + " : => " + s);
                }
            }
            if (curLevel == endLevel) {
                return;
            }
            this.incrIndent();
            for (int i = 0; i < children.length; ++i) {
                this.printEdge(children[i], tree, false, relName, multiplicity, curLevel + 1, endLevel);
            }
            this.decrIndent();
        }
    }

    private void incrIndent() {
        this.indent.append("|  ");
    }

    private void decrIndent() {
        int len = this.indent.length();
        if (len > 0) {
            this.indent.delete(len - 3, len);
        }
    }

    @Override
    public String usage() {
        return "void " + this.name + "(string srcNode [, string trgNode], EdgeSet edgeSet [, int level])";
    }
}

