/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.ShowDB;
import ca.uwaterloo.cs.jgrok.fb.Tree;
import ca.uwaterloo.cs.jgrok.interp.Scope;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.interp.Variable;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import ca.uwaterloo.cs.jgrok.lib.Show;
import java.util.ArrayList;
import java.util.Enumeration;

public class ShowTree
extends Function {
    private Env env;
    private StringBuffer indent = new StringBuffer();
    public static final int METHOD_UNKNOWN = 0;
    public static final int METHOD_DEFAULT_CONTAIN = 1;
    public static final int METHOD_DEFAULT_CONTAIN_LEVEL = 2;
    public static final int METHOD_CUSTOM_CONTAIN = 3;
    public static final int METHOD_CUSTOM_CONTAIN_LEVEL = 4;
    public static final int METHOD_DEFAULT_CONTAIN_CUSTOM_ROOT = 5;
    public static final int METHOD_DEFAULT_CONTAIN_CUSTOM_ROOT_LEVEL = 6;
    public static final int METHOD_CUSTOM_CONTAIN_CUSTOM_ROOT = 7;
    public static final int METHOD_CUSTOM_CONTAIN_CUSTOM_ROOT_LEVEL = 8;

    public ShowTree() {
        this.name = "showtree";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        int whichMethod = 0;
        int level = -1;
        EdgeSet contain = null;
        String singleton = null;
        boolean seenLevel = false;
        this.env = env;
        switch (vals.length) {
            case 0: {
                whichMethod = 1;
                break;
            }
            case 1: {
                Value value0 = vals[0];
                if (value0.isNumeric()) {
                    whichMethod = 2;
                    level = value0.intValue();
                    seenLevel = true;
                    break;
                }
                if (!value0.isEdgeSet()) {
                    whichMethod = 5;
                    singleton = value0.toString();
                    break;
                }
                whichMethod = 3;
                contain = value0.edgeSetValue();
                break;
            }
            case 2: {
                Value value0 = vals[0];
                Value value1 = vals[1];
                if (!value0.isEdgeSet()) {
                    whichMethod = 6;
                    singleton = vals[0].toString();
                    level = value1.intValue();
                    seenLevel = true;
                    break;
                }
                contain = value0.edgeSetValue();
                if (value1.isNumeric()) {
                    whichMethod = 4;
                    level = value1.intValue();
                    seenLevel = true;
                    break;
                }
                whichMethod = 7;
                singleton = value1.toString();
                break;
            }
            case 3: {
                whichMethod = 8;
                contain = (EdgeSet)vals[0].objectValue();
                singleton = vals[1].toString();
                level = vals[2].intValue();
                seenLevel = true;
                break;
            }
            default: {
                return this.illegalUsage();
            }
        }
        if (seenLevel && level < 0) {
            throw new InvocationException("illegal showtree level: " + level);
        }
        if (contain == null) {
            if (singleton == null) {
                contain = this.findContain();
            } else {
                try {
                    contain = this.findContain();
                }
                catch (Exception e) {
                    Show.print(env, IDManager.getID(singleton), env.peepScope());
                    return Value.VOID;
                }
            }
        }
        Tree tree = new Tree(contain);
        int[] roots = singleton == null ? tree.getRoots() : new int[]{IDManager.getID(singleton)};
        if (roots.length > 1) {
            StringBuffer buffer = new StringBuffer();
            for (int i = 0; i < roots.length; ++i) {
                buffer.append("\n\t" + IDManager.get(roots[i]));
            }
            throw new InvocationException("multiple roots found by showtree:" + buffer.toString());
        }
        if (roots.length == 1) {
            ShowDB showDB = this.buildShowDB(contain.getName());
            if (level < 0) {
                this.printNode(roots[0], tree, showDB);
            } else {
                this.printNode(roots[0], tree, showDB, 0, level);
            }
            return Value.VOID;
        }
        throw new InvocationException("no root found by showtree");
    }

    private EdgeSet findContain() throws InvocationException {
        try {
            Variable var = this.env.peepScope().lookup("contain");
            if (var.getType() != EdgeSet.class) {
                throw new InvocationException("contain is not relation");
            }
            return (EdgeSet)var.getValue().objectValue();
        }
        catch (Exception e) {
            throw new InvocationException("contain not found");
        }
    }

    private ShowDB buildShowDB(String relName) {
        ShowDB showDB = new ShowDB();
        Scope scp = this.env.peepScope();
        Enumeration<Variable> enm = scp.allVariables();
        while (enm.hasMoreElements()) {
            String varName;
            Variable var = enm.nextElement();
            Class<?> varType = var.getType();
            if (varType != EdgeSet.class || (varName = var.getName()).equals(relName)) continue;
            EdgeSet eSet = (EdgeSet)var.getValue().objectValue();
            if (varName.charAt(0) == '@' || varName.equals("$INSTANCE")) {
                showDB.addAtts(eSet);
                continue;
            }
            showDB.addRels(eSet);
        }
        showDB.setup();
        return showDB;
    }

    private void printNode(int node, Tree tree, ShowDB showDB) {
        this.showNode(node, tree, showDB);
        int[] children = tree.getChildren(node);
        if (children.length > 0) {
            this.incrIndent();
            for (int i = 0; i < children.length; ++i) {
                this.printNode(children[i], tree, showDB);
            }
            this.decrIndent();
        }
    }

    private void printNode(int node, Tree tree, ShowDB showDB, int curLevel, int endLevel) {
        this.showNode(node, tree, showDB);
        if (curLevel == endLevel) {
            return;
        }
        int[] children = tree.getChildren(node);
        if (children.length > 0) {
            this.incrIndent();
            for (int i = 0; i < children.length; ++i) {
                this.printNode(children[i], tree, showDB, curLevel + 1, endLevel);
            }
            this.decrIndent();
        }
    }

    private void showNode(int node, Tree tree, ShowDB showDB) {
        String[] atts = showDB.getAtts(node);
        ArrayList<String> rels = showDB.getRels(node);
        StringBuffer title = new StringBuffer();
        if (atts[0] == null) {
            title.append(IDManager.get(node));
            title.append(" : ");
            if (atts[1] != null) {
                title.append(atts[1]);
                title.append(' ');
            }
        } else {
            title.append(atts[0]);
            title.append(" : ");
            if (atts[1] != null) {
                title.append(atts[1]);
                title.append(" @ ");
            }
            title.append(IDManager.get(node));
            title.append(' ');
        }
        if (atts[2] != null) {
            title.append(atts[2]);
        }
        this.env.out.println(this.indent.toString() + title);
        for (int i = 0; i < rels.size(); ++i) {
            this.env.out.println(this.indent.toString() + "   " + rels.get(i));
        }
    }

    private void incrIndent() {
        this.indent.append("|  ");
    }

    private void decrIndent() {
        int len = this.indent.length();
        if (len > 0) {
            this.indent.delete(len - 3, len);
        }
    }

    @Override
    public String usage() {
        return "void " + this.name + "([EdgeSet relation] [,String rootNode] [, int level])";
    }
}

