/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.util.Arrays;
import java.util.Comparator;

public class Sort
extends Function {
    public Sort() {
        this.name = "sort";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        boolean ascending = true;
        int col = 0;
        boolean colSeen = false;
        switch (vals.length) {
            case 3: {
                ascending = vals[2].booleanValue();
                col = vals[1].intValue();
                colSeen = true;
            }
            case 2: {
                if (!colSeen) {
                    if (vals[1].isBoolean()) {
                        ascending = vals[1].booleanValue();
                    } else {
                        col = vals[1].intValue();
                        colSeen = true;
                    }
                }
            }
            case 1: {
                TupleSet tSet = vals[0].tupleSetValue();
                tSet = (TupleSet)tSet.clone();
                tSet.removeDuplicates();
                TupleSet result = tSet.newSet();
                Tuple[] data = tSet.getAllTuples();
                if (tSet.size() > 0) {
                    if (!colSeen) {
                        this.sort(data, result, 0, ascending);
                    } else {
                        if (data[0].size() <= col) {
                            throw new InvocationException("index " + col + " out of bounds " + data[0].size());
                        }
                        this.sort(data, result, col, ascending);
                    }
                }
                result.setHasDuplicates(false);
                return new Value(result);
            }
        }
        return this.illegalUsage();
    }

    private void sort(Tuple[] data, TupleSet result, int col, boolean upward) {
        try {
            Arrays.sort(data, new TupleNumCmp(col));
        }
        catch (NumberFormatException e) {
            Arrays.sort(data, new TupleLexCmp(col));
        }
        int count = data.length;
        if (upward) {
            for (int i = 0; i < count; ++i) {
                result.add(data[i]);
            }
        } else {
            for (int i = 1; i <= count; ++i) {
                result.add(data[count - i]);
            }
        }
    }

    @Override
    public String usage() {
        return "TupleSet " + this.name + "(TupleSet set [, int colIndex] [, boolean ascending])";
    }

    class TupleLexCmp
    implements Comparator<Tuple> {
        int col;

        TupleLexCmp(int col) {
            this.col = col;
        }

        @Override
        public int compare(Tuple t1, Tuple t2) {
            String s1 = IDManager.get(t1.get(this.col));
            String s2 = IDManager.get(t2.get(this.col));
            return s1.compareTo(s2);
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }

    class TupleNumCmp
    implements Comparator<Tuple> {
        int col;

        TupleNumCmp(int col) {
            this.col = col;
        }

        @Override
        public int compare(Tuple t1, Tuple t2) throws NumberFormatException {
            double d2;
            double d1 = Double.parseDouble(IDManager.get(t1.get(this.col)));
            if (d1 < (d2 = Double.parseDouble(IDManager.get(t2.get(this.col))))) {
                return -1;
            }
            if (d1 == d2) {
                return 0;
            }
            return 1;
        }

        @Override
        public boolean equals(Object o) {
            return false;
        }
    }
}

