/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Edge;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tree;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;

public class WriteDotty
extends Function {
    private static StringBuffer indent = new StringBuffer();

    public WriteDotty() {
        this.name = "writeDot";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 2: {
                return WriteDotty.action_2(vals);
            }
            case 3: {
                return WriteDotty.action_3(vals);
            }
        }
        return this.illegalUsage();
    }

    private static Value action_2(Value[] vals) throws InvocationException {
        String dotFile = vals[0].stringValue();
        EdgeSet dotLink = vals[1].edgeSetValue();
        PrintWriter writer = WriteDotty.getWriter(dotFile);
        WriteDotty.writeHead(writer, dotFile);
        WriteDotty.writeLinks(writer, dotLink);
        WriteDotty.writeTail(writer);
        writer.flush();
        return Value.VOID;
    }

    private static Value action_3(Value[] vals) throws InvocationException {
        String dotFile = vals[0].stringValue();
        EdgeSet dotLink = vals[1].edgeSetValue();
        EdgeSet contain = vals[2].edgeSetValue();
        PrintWriter writer = WriteDotty.getWriter(dotFile);
        Tree tree = new Tree(contain);
        int[] roots = tree.getRoots();
        if (roots.length > 1) {
            throw new InvocationException("multiple roots found by writeDot");
        }
        if (roots.length == 1) {
            WriteDotty.writeHead(writer, dotFile);
            WriteDotty.writeLinks(writer, dotLink);
            WriteDotty.writeClusters(writer, tree, roots[0]);
            writer.println();
            WriteDotty.writeTail(writer);
            writer.flush();
            return Value.VOID;
        }
        throw new InvocationException("no root found by writeDot");
    }

    private static PrintWriter getWriter(String dotFile) throws InvocationException {
        try {
            FileOutputStream fileOut = new FileOutputStream(new File(dotFile));
            return new PrintWriter(fileOut, true);
        }
        catch (IOException e) {
            throw new InvocationException(e.getMessage());
        }
    }

    private static void writeHead(PrintWriter writer, String title) {
        writer.println("digraph \"" + title + "\" {");
        WriteDotty.incrIndent();
        writer.println(indent + "size = \"8,6\";");
        writer.println();
    }

    private static void writeTail(PrintWriter writer) {
        WriteDotty.decrIndent();
        writer.println("}");
    }

    private static void writeLinks(PrintWriter writer, EdgeSet links) {
        Edge[] edges = links.getAllEdges();
        for (int i = 0; i < edges.length; ++i) {
            Edge e = edges[i];
            writer.println(indent + "\"" + e.getFrom() + "\"->\"" + e.getTo() + "\";");
        }
        writer.println();
    }

    private static void writeClusters(PrintWriter writer, Tree tree, int current) {
        int[] children = tree.getChildren(current);
        if (children.length > 0) {
            writer.println(indent + "subgraph \"cluster_" + current + "\" {");
            WriteDotty.incrIndent();
            writer.println(indent + "label=\"" + IDManager.get(current) + "\";");
            for (int i = 0; i < children.length; ++i) {
                WriteDotty.writeClusters(writer, tree, children[i]);
            }
            WriteDotty.decrIndent();
            writer.println(indent + "}");
        } else {
            writer.println(indent + "\"" + IDManager.get(current) + "\";");
        }
    }

    private static void incrIndent() {
        indent.append("    ");
    }

    private static void decrIndent() {
        int len = indent.length();
        if (len > 0) {
            indent.delete(len - 4, len);
        }
    }

    @Override
    public String usage() {
        return "void " + this.name + "(String dotFile, EdgeSet dotLink [, EdgeSet contain])";
    }
}

