/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib.math;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.util.Arrays;
import java.util.HashMap;

public class Max
extends Function {
    public Max() {
        this.name = "max";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 2: {
                return this.multiset(vals);
            }
            case 1: {
                double max = Double.MIN_VALUE;
                NodeSet set = vals[0].nodeSetValue();
                Node[] data = set.getAllNodes();
                NodeSet result = null;
                String s_max = null;
                for (int i = 0; i < data.length; ++i) {
                    try {
                        Node node = data[i];
                        String s = node.get();
                        double val = Double.parseDouble(s);
                        if (!(val >= max)) continue;
                        s_max = s;
                        max = val;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                result = s_max == null ? new NodeSet() : NodeSet.singleton(s_max);
                return new Value(result);
            }
        }
        return this.illegalUsage();
    }

    private Value multiset(Value[] vals) {
        NodeSet set = vals[0].nodeSetValue();
        int count = vals[1].intValue();
        NodeSet result = new NodeSet();
        if (count > 0) {
            Node[] data = set.getAllNodes();
            HashMap<Double, String> map = new HashMap<Double, String>(101, 0.75f);
            for (int i = 0; i < data.length; ++i) {
                try {
                    String s = data[i].get();
                    Double f = new Double(s);
                    map.put(f, s);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            Object[] keys = map.keySet().toArray();
            Arrays.sort(keys);
            int i = keys.length;
            while (--i >= 0 && count > 0) {
                result.add((String)map.get(keys[i]));
                --count;
            }
        }
        return new Value(result);
    }

    @Override
    public String usage() {
        return "NodeSet " + this.name + "(NodeSet set [, int count])";
    }
}

