/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib.math;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class Maxf
extends Function {
    public Maxf() {
        this.name = "maxf";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        if (vals.length != 1) {
            return this.illegalUsage();
        }
        boolean seen = false;
        double max = Double.MIN_VALUE;
        NodeSet set = vals[0].nodeSetValue();
        Node[] data = set.getAllNodes();
        for (int i = 0; i < data.length; ++i) {
            try {
                Node node = data[i];
                double val = Double.parseDouble(node.get());
                if (!(val >= max)) continue;
                max = val;
                seen = true;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (seen) {
            return new Value(max);
        }
        return Value.VOID;
    }

    @Override
    public String usage() {
        return "double " + this.name + "(NodeSet set)";
    }
}

