/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib.math;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.util.Arrays;
import java.util.HashMap;

public class Min
extends Function {
    public Min() {
        this.name = "min";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        switch (vals.length) {
            case 2: {
                return this.multiset(vals);
            }
            case 1: {
                double min = Double.MAX_VALUE;
                NodeSet set = vals[0].nodeSetValue();
                Node[] data = set.getAllNodes();
                NodeSet result = null;
                String s_min = null;
                for (int i = 0; i < data.length; ++i) {
                    try {
                        Node node = data[i];
                        String s = node.get();
                        double val = Double.parseDouble(s);
                        if (!(val <= min)) continue;
                        s_min = s;
                        min = val;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                result = s_min == null ? new NodeSet() : NodeSet.singleton(s_min);
                return new Value(result);
            }
        }
        return this.illegalUsage();
    }

    private Value multiset(Value[] vals) {
        NodeSet set = vals[0].nodeSetValue();
        int count = vals[1].intValue();
        NodeSet result = new NodeSet();
        if (count > 0) {
            Node[] data = set.getAllNodes();
            HashMap<Double, String> map = new HashMap<Double, String>(101, 0.75f);
            for (int i = 0; i < data.length; ++i) {
                try {
                    String s = data[i].get();
                    Double f = new Double(s);
                    map.put(f, s);
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            Object[] keys = map.keySet().toArray();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length && count > 0; ++i, --count) {
                result.add((String)map.get(keys[i]));
            }
        }
        return new Value(result);
    }

    @Override
    public String usage() {
        return "NodeSet " + this.name + "(NodeSet set [, int count])";
    }
}

