/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib.math;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.Node;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class Mini
extends Function {
    public Mini() {
        this.name = "mini";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        if (vals.length != 1) {
            return this.illegalUsage();
        }
        long min = Long.MAX_VALUE;
        boolean seen = false;
        NodeSet set = vals[0].nodeSetValue();
        Node[] data = set.getAllNodes();
        for (int i = 0; i < data.length; ++i) {
            try {
                Node node = data[i];
                long val = Long.parseLong(node.get());
                if (val > min) continue;
                min = val;
                seen = true;
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (seen) {
            return new Value(min);
        }
        return Value.VOID;
    }

    @Override
    public String usage() {
        return "long " + this.name + "(NodeSet set)";
    }
}

