/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib.math;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class Stdev
extends Function {
    public Stdev() {
        this.name = "stdev";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        int size;
        double sum = 0.0;
        double sum2 = 0.0;
        double result = 0.0;
        switch (vals.length) {
            case 1: {
                TupleSet input = vals[0].tupleSetValue();
                size = input.size();
                if (size <= 0) break;
                TupleList data = input.getTupleList();
                for (int i = 0; i < data.size(); ++i) {
                    Tuple tuple = data.get(i);
                    try {
                        double d = Double.parseDouble(IDManager.get(tuple.getDom()));
                        sum += d;
                        sum2 += d * d;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                break;
            }
            case 2: {
                int col = vals[1].intValue();
                TupleSet input = vals[0].tupleSetValue();
                size = input.size();
                if (size <= 0) break;
                TupleList data = input.getTupleList();
                for (int i = 0; i < data.size(); ++i) {
                    Tuple tuple = data.get(i);
                    if (col >= tuple.size()) continue;
                    try {
                        double d = Double.parseDouble(IDManager.get(tuple.get(col)));
                        sum += d;
                        sum2 += d * d;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                break;
            }
            default: {
                return this.illegalUsage();
            }
        }
        if (size > 0) {
            double mean = sum / (double)size;
            double mean2 = sum2 / (double)size;
            result = Math.sqrt(mean2 - mean * mean);
        }
        return new Value(result);
    }

    @Override
    public String usage() {
        return "double " + this.name + "(NodeSet set [, int column])";
    }
}

