/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib.math;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;

public class Sum
extends Function {
    public Sum() {
        this.name = "sum";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        double result = 0.0;
        switch (vals.length) {
            case 1: {
                TupleSet input = vals[0].tupleSetValue();
                if (input.size() <= 0) break;
                TupleList data = input.getTupleList();
                for (int i = 0; i < data.size(); ++i) {
                    Tuple tuple = data.get(i);
                    try {
                        result += Double.parseDouble(IDManager.get(tuple.getDom()));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                break;
            }
            case 2: {
                TupleSet input = vals[0].tupleSetValue();
                if (input.size() <= 0) break;
                int col = vals[1].intValue();
                TupleList data = input.getTupleList();
                for (int i = 0; i < data.size(); ++i) {
                    Tuple tuple = data.get(i);
                    if (col < tuple.size()) {
                        try {
                            result += Double.parseDouble(IDManager.get(tuple.get(col)));
                        }
                        catch (NumberFormatException e) {}
                        continue;
                    }
                    throw new InvocationException("index " + col + " out of bounds " + tuple.size());
                }
                break;
            }
            default: {
                return this.illegalUsage();
            }
        }
        return new Value(result);
    }

    @Override
    public String usage() {
        return "double " + this.name + "(NodeSet set [, int column])";
    }
}

