/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.lib.time;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.Value;
import ca.uwaterloo.cs.jgrok.lib.Function;
import ca.uwaterloo.cs.jgrok.lib.InvocationException;
import java.text.DateFormat;
import java.util.Date;

public class DateTime
extends Function {
    static Date m_date = new Date();
    static DateFormat[] m_dateFormats = new DateFormat[25];

    public DateTime() {
        this.name = "dateTime";
    }

    @Override
    public Value invoke(Env env, Value[] vals) throws InvocationException {
        if (vals.length < 1 || vals.length > 3) {
            return this.illegalUsage();
        }
        try {
            int mode;
            DateFormat dateFormat;
            int date;
            int time = -1;
            long millsecs = vals[0].longValue();
            switch (vals.length) {
                case 3: {
                    time = vals[2].intValue();
                    if (time < 0 || time > 3) {
                        time = -1;
                    }
                }
                case 2: {
                    date = vals[1].intValue();
                    if (date >= 0 && date <= 3) break;
                    date = -1;
                    break;
                }
                default: {
                    date = 0;
                    time = 0;
                }
            }
            if ((dateFormat = m_dateFormats[mode = (date + 1) * 5 + time + 1]) == null) {
                if (0 <= date) {
                    dateFormat = 0 <= time ? DateFormat.getDateTimeInstance(date, time) : DateFormat.getDateInstance(date);
                } else if (0 <= time) {
                    dateFormat = DateFormat.getTimeInstance(time);
                } else {
                    return new Value("");
                }
                DateTime.m_dateFormats[mode] = dateFormat;
            }
            m_date.setTime(millsecs);
            return new Value(dateFormat.format(m_date));
        }
        catch (Exception e) {
            throw new InvocationException(e.getMessage());
        }
    }

    @Override
    public String usage() {
        return "String " + this.name + "(long, [int], [int])";
    }
}

