/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.test;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.env.LoadingException;
import ca.uwaterloo.cs.jgrok.test.Regression;
import ca.uwaterloo.cs.jgrok.test.RegressionLoader;
import ca.uwaterloo.cs.jgrok.test.RegressionTest;
import ca.uwaterloo.cs.jgrok.util.Timing;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Scanner;

public class Regress {
    private Env env = new Env();

    public void executeRegression(String regressFileName) {
        Timing timing = new Timing();
        Regression regress = new Regression();
        RegressionLoader regressLoader = new RegressionLoader(regress);
        try {
            timing.start();
            this.env.out.println("Loading Regression File=" + regressFileName + " ...");
            regressLoader.load(this.env, Regression.getRegressHome() + File.separator + regressFileName);
            Iterator<RegressionTest> iter = regress.iterator();
            while (iter.hasNext()) {
                RegressionTest test = iter.next();
                String result = test.execute(this.env);
                this.env.out.println("\t" + result);
            }
            timing.stop();
            this.env.out.println("\tTotal Time=" + timing.getTime() + "sec");
        }
        catch (LoadingException e) {
            e.printStackTrace(System.err);
            return;
        }
    }

    public static void main(String[] args) {
        Regress program = new Regress();
        for (String regressFileName : args) {
            program.executeRegression(regressFileName);
        }
    }

    public static class Diff {
        private String file1;
        private String file2;

        public Diff(String f1, String f2) {
            this.file1 = f1;
            this.file2 = f2;
        }

        public boolean execute(PrintStream out) throws FileNotFoundException {
            int j;
            int i;
            boolean noDiff = true;
            Scanner s1 = null;
            Scanner s2 = null;
            try {
                s1 = new Scanner(new File(this.file1)).useDelimiter("\\n");
                s2 = new Scanner(new File(this.file2)).useDelimiter("\\n");
            }
            catch (Exception e) {
                throw new FileNotFoundException(e.getMessage());
            }
            ArrayList<String> list1 = new ArrayList<String>(500);
            while (s1.hasNextLine()) {
                list1.add(s1.nextLine());
            }
            ArrayList<String> list2 = new ArrayList<String>(500);
            while (s2.hasNextLine()) {
                list2.add(s2.nextLine());
            }
            int M = list1.size();
            int N = list2.size();
            int[][] opt = new int[M + 1][N + 1];
            for (i = M - 1; i >= 0; --i) {
                for (j = N - 1; j >= 0; --j) {
                    opt[i][j] = ((String)list1.get(i)).equals(list2.get(j)) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
                }
            }
            i = 0;
            j = 0;
            while (i < M && j < N) {
                if (((String)list1.get(i)).equals(list2.get(j))) {
                    ++i;
                    ++j;
                    continue;
                }
                noDiff = false;
                if (opt[i + 1][j] >= opt[i][j + 1]) {
                    out.println("< " + (String)list1.get(i++));
                    continue;
                }
                out.println("> " + (String)list2.get(j++));
            }
            while (i < M || j < N) {
                noDiff = false;
                if (i == M) {
                    out.println("> " + (String)list2.get(j++));
                    continue;
                }
                if (j != N) continue;
                out.println("< " + (String)list1.get(i++));
            }
            return noDiff;
        }
    }
}

