/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.test;

import ca.uwaterloo.cs.jgrok.env.Env;
import ca.uwaterloo.cs.jgrok.interp.Interp;
import ca.uwaterloo.cs.jgrok.test.Regress;
import ca.uwaterloo.cs.jgrok.test.Regression;
import ca.uwaterloo.cs.jgrok.util.Timing;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class RegressionTest {
    private String name = null;
    private boolean enabled = true;
    private boolean success = true;
    private Regression regress = null;
    private Timing timing = new Timing();
    private String scriptFile = null;
    private String inputFile = null;
    private String logFile = null;
    private ArrayList<String> argList;

    public RegressionTest(Regression regress) {
        this.regress = regress;
        this.argList = new ArrayList(5);
        this.regress.add(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getScriptFile() {
        return this.scriptFile;
    }

    public void setScriptFile(String scriptFile) {
        this.scriptFile = scriptFile;
    }

    public String getInputFile() {
        return this.inputFile;
    }

    public void setInputFile(String inputFile) {
        this.inputFile = inputFile;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setState(String state) {
        if (state.equalsIgnoreCase("ON")) {
            this.setEnabled(true);
        } else if (state.equalsIgnoreCase("OFF")) {
            this.setEnabled(false);
        } else {
            throw new IllegalArgumentException("state");
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean b) {
        this.success = b;
    }

    public int countArguments() {
        return this.argList.size();
    }

    public void clearArguments() {
        this.argList.clear();
    }

    public void addArgument(String value) {
        this.argList.add(value);
    }

    public String[] getArguments() {
        String[] result = new String[this.argList.size()];
        this.argList.toArray(result);
        return result;
    }

    protected String getResult() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled()) {
            if (this.isSuccess()) {
                buf.append("S");
            } else {
                buf.append("F");
            }
        } else {
            buf.append("_");
        }
        buf.append(' ');
        buf.append("Test=");
        buf.append(this.getName());
        buf.append(' ');
        buf.append("Time=");
        buf.append(this.timing.getTime());
        buf.append("sec");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute(Env env) {
        if (!this.isEnabled()) {
            return this.getResult();
        }
        this.timing.start();
        int argCount = 1;
        if (this.inputFile != null) {
            ++argCount;
        }
        String[] args = null;
        args = new String[argCount += this.countArguments()];
        args[0] = Regression.getRegressHome() + File.separator + this.regress.getInput() + File.separator + this.getScriptFile();
        if (this.inputFile != null) {
            args[1] = Regression.getRegressHome() + File.separator + this.regress.getInput() + File.separator + this.inputFile;
            System.arraycopy(this.getArguments(), 0, args, 2, this.countArguments());
        } else {
            System.arraycopy(this.getArguments(), 0, args, 1, this.countArguments());
        }
        String logFileName = Regression.getRegressHome();
        logFileName = logFileName + File.separator + this.regress.getInput();
        logFileName = logFileName + File.separator + this.getLogFile();
        String outFileName = Regression.getRegressResultHome();
        outFileName = outFileName + File.separator + this.regress.getOutput();
        outFileName = outFileName + File.separator + this.getLogFile();
        File outFile = new File(outFileName);
        PrintStream oldEnvOut = env.out;
        PrintStream newEnvOut = env.out;
        try {
            File outPath = outFile.getParentFile();
            if (!outPath.exists()) {
                outPath.mkdirs();
            }
            if (!outFile.exists()) {
                outFile.createNewFile();
            }
            env.out = newEnvOut = new PrintStream(outFile);
        }
        catch (Exception e) {
            env.out = oldEnvOut;
            e.printStackTrace(env.err);
        }
        File file = new File(args[0]);
        try {
            Interp interp = Interp.reinit(file);
            interp.fileEvaluate(env, args);
        }
        catch (Exception e) {
            e.printStackTrace(env.err);
        }
        finally {
            env.out = oldEnvOut;
        }
        String difFileName = Regression.getRegressResultHome();
        difFileName = difFileName + File.separator + this.regress.getOutput();
        difFileName = difFileName + File.separator + outFile.getName();
        difFileName = difFileName.replace(".log", ".dif");
        File difFile = new File(difFileName);
        String sucFileName = difFileName.replace(".dif", ".suc");
        File sucFile = new File(sucFileName);
        try {
            File difPath = difFile.getParentFile();
            if (!difPath.exists()) {
                difPath.mkdirs();
            }
            if (!difFile.exists()) {
                difFile.createNewFile();
            }
            PrintStream difOut = new PrintStream(difFile);
            Regress.Diff diff = new Regress.Diff(logFileName, outFileName);
            boolean noDiff = diff.execute(difOut);
            difOut.close();
            if (noDiff) {
                this.setSuccess(true);
                if (sucFile.exists()) {
                    difFile.delete();
                } else {
                    difFile.renameTo(sucFile);
                }
            } else {
                if (sucFile.exists()) {
                    sucFile.delete();
                }
                this.setSuccess(false);
            }
        }
        catch (Exception e) {
            e.printStackTrace(env.err);
        }
        finally {
            env.out = oldEnvOut;
        }
        this.timing.stop();
        return this.getResult();
    }
}

