/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.util;

import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.util.SimRank;
import java.util.ArrayList;
import java.util.HashMap;

public class SimInitialization {
    protected Object userData;
    protected TupleList feature;

    public SimInitialization(EdgeSet hasFeature, Object userData) {
        this.feature = new TupleList(hasFeature.size());
        RadixSorter.sort(hasFeature.getTupleList(), 0, this.feature);
    }

    public void initialize(SimRank simRank) {
        ArrayList<SimRank.Entry> list = simRank.ePool.entryList;
        int simCol = simRank.simCol;
        int count = list.size();
        for (int i = 0; i < count; ++i) {
            SimRank.Entry e = list.get(i);
            if (!(e.sims[simCol] < 1.0)) continue;
            e.sims[0] = this.getInitialSim(e.elem1, e.elem2);
            e.sims[1] = e.sims[0];
        }
    }

    protected double getInitialSim(int ID1, int ID2) {
        Integer v;
        Tuple t;
        int i;
        if (ID1 == ID2) {
            return 1.0;
        }
        int length = this.feature.size();
        int index1 = BinarySearch.search(this.feature, ID1, 0);
        int index2 = BinarySearch.search(this.feature, ID2, 0);
        if (index1 < 0 || index2 < 0) {
            return 0.0;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>(17);
        for (i = index1; i < length && ID1 == (t = this.feature.get(i)).getDom(); ++i) {
            v = new Integer(t.getRng());
            if (map.containsKey(v)) continue;
            map.put(v, v);
        }
        int common = 0;
        int sum = i - index1;
        for (i = index2; i < length; ++i) {
            t = this.feature.get(i);
            if (ID2 != t.getDom()) continue;
            v = new Integer(t.getRng());
            if (map.containsKey(v)) {
                ++common;
                continue;
            }
            ++sum;
        }
        return (double)common / (double)sum;
    }
}

