/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.util;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.IDManager;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleFactory;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.fb.TupleSet;
import java.util.ArrayList;
import java.util.HashMap;

public class SimRank {
    int simCol = 0;
    EntryPool ePool = new EntryPool();
    TupleList graph;
    protected double epsilon = 0.001;
    protected double decayFactor = 0.8;

    public SimRank(EdgeSet aGraph) {
        this.graph = new TupleList(aGraph.size());
        RadixSorter.sort(aGraph.getTupleList(), 0, this.graph);
        this.initEntryPool(aGraph);
    }

    protected void initEntryPool(EdgeSet aGraph) {
        NodeSet nodes = AlgebraOperation.entityOf(aGraph);
        EdgeSet edges = AlgebraOperation.crossProduct(nodes, nodes);
        TupleList pairs = edges.getTupleList();
        for (int i = 0; i < pairs.size(); ++i) {
            Entry e = this.ePool.getEntry(pairs.get(i));
            if (e != null) continue;
            e = this.ePool.putEntry(pairs.get(i));
            this.processEntry(e);
        }
    }

    protected void processEntry(Entry e) {
        Tuple t2;
        int j;
        Tuple t1;
        int i;
        int length = this.graph.size();
        int index1 = BinarySearch.search(this.graph, e.elem1, 0);
        int index2 = BinarySearch.search(this.graph, e.elem2, 0);
        if (index1 < 0 || index2 < 0) {
            return;
        }
        int count1 = 0;
        int count2 = 0;
        for (i = index1; i < length && (t1 = this.graph.get(i)).getDom() == e.elem1; ++i) {
            ++count1;
        }
        for (j = index2; j < length && (t2 = this.graph.get(j)).getDom() == e.elem2; ++j) {
            ++count2;
        }
        int length1 = index1 + count1;
        int length2 = index2 + count2;
        for (i = index1; i < length1; ++i) {
            t1 = this.graph.get(i);
            for (j = index2; j < length2; ++j) {
                t2 = this.graph.get(j);
                Entry tmp = this.ePool.getEntry(t1.getRng(), t2.getRng());
                if (tmp != null) continue;
                tmp = this.ePool.putEntry(t1.getRng(), t2.getRng());
                this.processEntry(tmp);
            }
        }
    }

    public double getDecayFactor() {
        return this.decayFactor;
    }

    public void setDecayFactor(double d) {
        this.decayFactor = d;
    }

    public double querySim(Tuple t) {
        Entry e = this.ePool.getEntry(t);
        if (e != null) {
            return e.sims[this.simCol];
        }
        return 0.0;
    }

    public TupleSet compute(int iterationCount) {
        Entry e;
        int writeCol = 0;
        ArrayList<Entry> list = this.ePool.entryList;
        int count = list.size();
        for (int i = 0; i < iterationCount; ++i) {
            int readCol = i % 2;
            writeCol = (readCol + 1) % 2;
            for (int j = 0; j < count; ++j) {
                e = list.get(j);
                if (e.sims[readCol] < 1.0) {
                    this.computeEntry(e, readCol, writeCol);
                    continue;
                }
                e.sims[writeCol] = 1.0;
            }
        }
        this.simCol = writeCol;
        int[] ids = new int[3];
        TupleSet tSet = new TupleSet(count);
        for (int i = 0; i < count; ++i) {
            e = list.get(i);
            ids[0] = e.elem1;
            ids[1] = e.elem2;
            ids[2] = this.stringID(e.sims[this.simCol]);
            tSet.add(TupleFactory.create(ids, true));
        }
        return tSet;
    }

    private int stringID(double d) {
        String s;
        if (d < this.epsilon) {
            d = 0.0;
        }
        if ((s = (double)Math.round(d / this.epsilon) * this.epsilon + "").length() > 5) {
            s = s.substring(0, 5);
        }
        return IDManager.getID(s);
    }

    protected void computeEntry(Entry e, int readCol, int writeCol) {
        Tuple t2;
        int j;
        Tuple t1;
        int i;
        int length = this.graph.size();
        int index1 = BinarySearch.search(this.graph, e.elem1, 0);
        int index2 = BinarySearch.search(this.graph, e.elem2, 0);
        if (index1 < 0 || index2 < 0) {
            return;
        }
        int count1 = 0;
        int count2 = 0;
        for (i = index1; i < length && (t1 = this.graph.get(i)).getDom() == e.elem1; ++i) {
            ++count1;
        }
        for (j = index2; j < length && (t2 = this.graph.get(j)).getDom() == e.elem2; ++j) {
            ++count2;
        }
        double sum = 0.0;
        int length1 = index1 + count1;
        int length2 = index2 + count2;
        for (i = index1; i < length1; ++i) {
            t1 = this.graph.get(i);
            for (j = index2; j < length2; ++j) {
                t2 = this.graph.get(j);
                Entry tmp = this.ePool.getEntry(t1.getRng(), t2.getRng());
                sum += tmp.sims[readCol];
            }
        }
        double sim = sum * this.decayFactor / (double)(count1 * count2);
        e.sims[writeCol] = sim > e.sims[readCol] ? sim : e.sims[readCol];
    }

    static class Entry {
        int elem1;
        int elem2;
        boolean outNeighbour = true;
        double[] sims = new double[2];

        Entry(Tuple t) {
            this(t.getDom(), t.getRng());
        }

        Entry(int elem1, int elem2) {
            this.elem1 = elem1;
            this.elem2 = elem2;
            if (elem1 == elem2) {
                this.sims[0] = 1.0;
                this.sims[1] = 1.0;
            } else {
                this.sims[0] = 0.0;
                this.sims[1] = 0.0;
            }
        }
    }

    static class EntryPool {
        int s_index = 0;
        ArrayList<Entry> entryList = new ArrayList(1997);
        HashMap<String, Entry> allStrings = new HashMap(1997, 0.75f);

        EntryPool() {
        }

        Entry putEntry(Tuple t) {
            return this.putEntry(t.getDom(), t.getRng());
        }

        Entry getEntry(Tuple t) {
            return this.getEntry(t.getDom(), t.getRng());
        }

        Entry putEntry(int elem1, int elem2) {
            String name;
            Entry entry;
            if (elem1 > elem2) {
                int tmp = elem1;
                elem1 = elem2;
                elem2 = tmp;
            }
            if ((entry = this.allStrings.get(name = elem1 + ":" + elem2)) != null) {
                return entry;
            }
            entry = new Entry(elem1, elem2);
            this.entryList.add(this.s_index, entry);
            this.allStrings.put(name, entry);
            ++this.s_index;
            return entry;
        }

        Entry getEntry(int elem1, int elem2) {
            if (elem1 > elem2) {
                int tmp = elem1;
                elem1 = elem2;
                elem2 = tmp;
            }
            String name = elem1 + ":" + elem2;
            return this.allStrings.get(name);
        }
    }
}

