/*
 * Decompiled with CFR 0.152.
 */
package ca.uwaterloo.cs.jgrok.util;

import ca.uwaterloo.cs.jgrok.fb.AlgebraOperation;
import ca.uwaterloo.cs.jgrok.fb.BinarySearch;
import ca.uwaterloo.cs.jgrok.fb.EdgeSet;
import ca.uwaterloo.cs.jgrok.fb.NodeSet;
import ca.uwaterloo.cs.jgrok.fb.RadixSorter;
import ca.uwaterloo.cs.jgrok.fb.Tuple;
import ca.uwaterloo.cs.jgrok.fb.TupleList;
import ca.uwaterloo.cs.jgrok.util.SimRank;

public class SimRankBipartite
extends SimRank {
    TupleList shadow;

    public SimRankBipartite(EdgeSet aGraph) {
        super(aGraph);
    }

    public boolean inBipartiteDomain(Tuple t) {
        return this.inBipartiteDomain(t.getDom(), t.getRng());
    }

    public boolean inBipartiteRange(Tuple t) {
        return this.inBipartiteRange(t.getDom(), t.getRng());
    }

    public boolean inBipartiteDomain(int ID1, int ID2) {
        int domCol = 0;
        int index1 = BinarySearch.search(this.graph, ID1, domCol);
        int index2 = BinarySearch.search(this.graph, ID2, domCol);
        return index1 >= 0 && index2 >= 0;
    }

    public boolean inBipartiteRange(int ID1, int ID2) {
        int rngCol = 1;
        int index1 = BinarySearch.search(this.shadow, ID1, rngCol);
        int index2 = BinarySearch.search(this.shadow, ID2, rngCol);
        return index1 >= 0 && index2 >= 0;
    }

    @Override
    protected void initEntryPool(EdgeSet aGraph) {
        SimRank.Entry e;
        Tuple t;
        int i;
        this.shadow = new TupleList(aGraph.size());
        RadixSorter.sort(aGraph.getTupleList(), 1, this.shadow);
        NodeSet nodes = AlgebraOperation.domainOf(aGraph);
        EdgeSet edges = AlgebraOperation.crossProduct(nodes, nodes);
        TupleList tList = edges.getTupleList();
        for (i = 0; i < tList.size(); ++i) {
            t = tList.get(i);
            e = this.ePool.getEntry(t);
            if (e != null) continue;
            e = this.ePool.putEntry(t);
            e.outNeighbour = true;
            this.processEntry(e);
        }
        nodes = AlgebraOperation.rangeOf(aGraph);
        edges = AlgebraOperation.crossProduct(nodes, nodes);
        tList = edges.getTupleList();
        for (i = 0; i < tList.size(); ++i) {
            t = tList.get(i);
            e = this.ePool.getEntry(t);
            if (e != null) continue;
            e = this.ePool.putEntry(t);
            e.outNeighbour = false;
            this.processEntry(e);
        }
    }

    @Override
    protected void processEntry(SimRank.Entry e) {
        Tuple t2;
        int j;
        Tuple t1;
        int i;
        int valueCol;
        int searchCol;
        TupleList tList;
        if (e.outNeighbour) {
            tList = this.graph;
            searchCol = 0;
            valueCol = 1;
        } else {
            tList = this.shadow;
            searchCol = 1;
            valueCol = 0;
        }
        int length = tList.size();
        int index1 = BinarySearch.search(tList, e.elem1, searchCol);
        int index2 = BinarySearch.search(tList, e.elem2, searchCol);
        if (index1 < 0 || index2 < 0) {
            return;
        }
        int count1 = 0;
        int count2 = 0;
        for (i = index1; i < length && (t1 = tList.get(i)).get(searchCol) == e.elem1; ++i) {
            ++count1;
        }
        for (j = index2; j < length && (t2 = tList.get(j)).get(searchCol) == e.elem2; ++j) {
            ++count2;
        }
        int length1 = index1 + count1;
        int length2 = index2 + count2;
        for (i = index1; i < length1; ++i) {
            t1 = tList.get(i);
            for (j = index2; j < length2; ++j) {
                t2 = tList.get(j);
                SimRank.Entry tmp = this.ePool.getEntry(t1.get(valueCol), t2.get(valueCol));
                if (tmp != null) continue;
                tmp = this.ePool.putEntry(t1.get(valueCol), t2.get(valueCol));
                tmp.outNeighbour = !e.outNeighbour;
                this.processEntry(tmp);
            }
        }
    }

    @Override
    protected void computeEntry(SimRank.Entry e, int readCol, int writeCol) {
        Tuple t2;
        int j;
        Tuple t1;
        int i;
        int valueCol;
        int searchCol;
        TupleList tList;
        if (e.outNeighbour) {
            tList = this.graph;
            searchCol = 0;
            valueCol = 1;
        } else {
            tList = this.shadow;
            searchCol = 1;
            valueCol = 0;
        }
        int length = tList.size();
        int index1 = BinarySearch.search(tList, e.elem1, searchCol);
        int index2 = BinarySearch.search(tList, e.elem2, searchCol);
        if (index1 < 0 || index2 < 0) {
            return;
        }
        int count1 = 0;
        int count2 = 0;
        for (i = index1; i < length && (t1 = tList.get(i)).get(searchCol) == e.elem1; ++i) {
            ++count1;
        }
        for (j = index2; j < length && (t2 = tList.get(j)).get(searchCol) == e.elem2; ++j) {
            ++count2;
        }
        double sum = 0.0;
        int length1 = index1 + count1;
        int length2 = index2 + count2;
        for (i = index1; i < length1; ++i) {
            t1 = tList.get(i);
            for (j = index2; j < length2; ++j) {
                t2 = tList.get(j);
                SimRank.Entry tmp = this.ePool.getEntry(t1.get(valueCol), t2.get(valueCol));
                sum += tmp.sims[readCol];
            }
        }
        double sim = sum * this.decayFactor / (double)(count1 * count2);
        e.sims[writeCol] = sim > e.sims[readCol] ? sim : e.sims[readCol];
    }
}

