/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.readline;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import org.gnu.readline.ReadlineCompleter;
import org.gnu.readline.ReadlineLibrary;

public class Readline {
    private static ReadlineCompleter iCompleter = null;
    private static ReadlineLibrary iLib = ReadlineLibrary.PureJava;
    private static BufferedReader iReader = null;
    private static String iEncoding = System.getProperty("readline.encoding", null);
    private static boolean iThrowException = false;

    public static final void load(ReadlineLibrary lib) throws UnsatisfiedLinkError {
        if (lib == iLib) {
            return;
        }
        if (lib == ReadlineLibrary.PureJava) {
            iLib = lib;
            return;
        }
        System.loadLibrary(lib.getName());
        iLib = lib;
    }

    public static void initReadline(String applicationName) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline || iLib == ReadlineLibrary.Getline) {
            Readline.initReadlineImpl(applicationName);
        }
    }

    public static String readline(String prompt) throws EOFException, IOException, UnsupportedEncodingException {
        return Readline.readline(prompt, true);
    }

    public static String readline(String prompt, boolean addToHist) throws EOFException, IOException, UnsupportedEncodingException {
        String line;
        if (iLib != ReadlineLibrary.PureJava) {
            String line2 = Readline.readlineImpl(prompt);
            if (line2 != null && addToHist) {
                Readline.addToHistory(line2);
            }
            return line2;
        }
        System.out.print(prompt);
        if (iReader == null) {
            iReader = iEncoding == null ? new BufferedReader(new InputStreamReader(System.in)) : new BufferedReader(new InputStreamReader(System.in, iEncoding));
        }
        if ((line = iReader.readLine()) == null) {
            throw new EOFException("EOF");
        }
        if (line.length() == 0) {
            line = null;
        }
        return line;
    }

    public static void addToHistory(String line) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline || iLib == ReadlineLibrary.Getline) {
            Readline.addToHistoryImpl(line);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void getHistory(Collection collection) {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.getHistoryImpl(collection);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static int getHistorySize() {
        int result = 0;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            result = Readline.getHistorySizeImpl();
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    public static void clearHistory() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.clearHistoryImpl();
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static String getHistoryLine(int i) {
        String s = null;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            if (i < 0 || i >= Readline.getHistorySize()) {
                throw new ArrayIndexOutOfBoundsException(i);
            }
            s = Readline.getHistoryLineImpl(i);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return s;
    }

    public static void readInitFile(String filename) throws IOException {
        if (iLib == ReadlineLibrary.GnuReadline) {
            Readline.readInitFileImpl(filename);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static boolean parseAndBind(String line) {
        if (iLib == ReadlineLibrary.GnuReadline) {
            return Readline.parseAndBindImpl(line);
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return true;
    }

    public static void readHistoryFile(String filename) throws EOFException, UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.readHistoryFileImpl(filename);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void writeHistoryFile(String filename) throws EOFException, UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.writeHistoryFileImpl(filename);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void setCompleter(ReadlineCompleter rlc) {
        iCompleter = rlc;
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.setCompleterImpl(iCompleter);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static ReadlineCompleter getCompleter() {
        return iCompleter;
    }

    public static void cleanup() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.cleanupReadlineImpl();
        }
    }

    public static boolean hasTerminal() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.hasTerminalImpl();
        }
        return true;
    }

    public static String getWordBreakCharacters() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.getWordBreakCharactersImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static String getLineBuffer() {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            return Readline.getLineBufferImpl();
        }
        if (iThrowException) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    public static void setWordBreakCharacters(String wordBreakCharacters) throws UnsupportedEncodingException {
        if (iLib == ReadlineLibrary.GnuReadline || iLib == ReadlineLibrary.Editline) {
            Readline.setWordBreakCharactersImpl(wordBreakCharacters);
        } else if (iThrowException) {
            throw new UnsupportedOperationException();
        }
    }

    public static void setThrowExceptionOnUnsupportedMethod(boolean flag) {
        iThrowException = flag;
    }

    public static boolean getThrowExceptionOnUnsupportedMethod() {
        return iThrowException;
    }

    public static void setEncoding(String encoding) {
        iEncoding = encoding;
    }

    public static String getEncoding() {
        return iEncoding;
    }

    private static native void initReadlineImpl(String var0);

    private static native void cleanupReadlineImpl();

    private static native boolean hasTerminalImpl();

    private static native String readlineImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void addToHistoryImpl(String var0);

    private static native void getHistoryImpl(Collection var0);

    private static native int getHistorySizeImpl();

    private static native String getHistoryLineImpl(int var0);

    private static native void clearHistoryImpl();

    private static native void readInitFileImpl(String var0) throws IOException;

    private static native String getLineBufferImpl();

    private static native boolean parseAndBindImpl(String var0);

    private static native void readHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void writeHistoryFileImpl(String var0) throws EOFException, UnsupportedEncodingException;

    private static native void setCompleterImpl(ReadlineCompleter var0);

    private static native String getWordBreakCharactersImpl();

    private static native void setWordBreakCharactersImpl(String var0) throws UnsupportedEncodingException;
}

