/*
 * Decompiled with CFR 0.152.
 */
package org.gnu.readline;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.gnu.readline.Readline;
import org.gnu.readline.ReadlineLibrary;

public class ReadlineReader
extends Reader {
    public static final String DEFAULT_PROMPT = "";
    private StringBuffer iBuff = new StringBuffer();
    private String iLineSeparator;
    private String iPrompt;
    private File iHistoryFile;

    public ReadlineReader(String prompt, ReadlineLibrary lib) {
        this.setPrompt(prompt);
        Readline.load(lib);
        Readline.initReadline("ReadlineReader");
        this.iLineSeparator = System.getProperty("line.separator", "\n");
    }

    public ReadlineReader(ReadlineLibrary lib) {
        this(DEFAULT_PROMPT, lib);
    }

    public ReadlineReader(File history, ReadlineLibrary lib) throws IOException {
        this(DEFAULT_PROMPT, lib);
        Readline.readHistoryFile(history.getAbsolutePath());
        this.iHistoryFile = history;
    }

    public ReadlineReader(String prompt, File history, ReadlineLibrary lib) throws IOException {
        this(history, lib);
        this.setPrompt(prompt);
    }

    public String getPrompt() {
        return this.iPrompt;
    }

    public void setPrompt(String prompt) {
        this.iPrompt = prompt;
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        try {
            if (this.iBuff.length() == 0) {
                String line = Readline.readline(this.iPrompt);
                this.iBuff.append((line == null ? DEFAULT_PROMPT : line) + this.iLineSeparator);
            }
            if (len > this.iBuff.length()) {
                len = this.iBuff.length();
            }
            if (len == 0) {
                return 0;
            }
            char[] sbuf = this.iBuff.substring(0, len).toCharArray();
            System.arraycopy(sbuf, 0, cbuf, off, len);
            this.iBuff.delete(0, len);
            return len;
        }
        catch (EOFException eof) {
            throw eof;
        }
        catch (UnsupportedEncodingException uee) {
            throw uee;
        }
    }

    @Override
    public void close() throws IOException {
        this.iBuff = null;
        this.iPrompt = null;
        if (this.iHistoryFile != null) {
            Readline.writeHistoryFile(this.iHistoryFile.getAbsolutePath());
            this.iHistoryFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        BufferedReader rd = new BufferedReader(new ReadlineReader("hmm ", new File("test"), ReadlineLibrary.GnuReadline));
        try {
            String line;
            while ((line = rd.readLine()) != null) {
                System.out.println("got: " + line);
            }
        }
        finally {
            rd.close();
        }
    }
}

