/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Rectangle;
import lsedit.Diagram;
import lsedit.TextBox;

public abstract class ArrowButton
extends Canvas {
    public static final int BTN_DOWN = 0;
    public static final int BTN_UP = 1;
    public static final int BTN_LEFT = 2;
    public static final int BTN_RIGHT = 3;
    protected TextBox tb;
    protected boolean enabled = true;
    protected boolean upState = true;
    protected int btnKind;
    protected int dim;

    protected abstract void handleClick();

    public ArrowButton(int n, int n2) {
        this.dim = n;
        this.btnKind = n2;
        this.resize(n, n);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Diagram.boxColour);
        graphics.fillRect(0, 0, this.dim, this.dim);
        graphics.draw3DRect(0, 0, this.dim, this.dim, this.upState);
        graphics.draw3DRect(1, 1, this.dim - 2, this.dim - 2, this.upState);
        graphics.setColor(this.enabled ? Color.black : Color.gray);
        int n = this.upState ? 0 : 1;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        switch (this.btnKind) {
            case 0: {
                nArray[0] = 4 + n;
                nArray2[0] = 4 + n;
                nArray[1] = this.dim - 4 + n;
                nArray2[1] = 4 + n;
                nArray[2] = this.dim / 2 + n;
                nArray2[2] = this.dim - 4 + n;
                break;
            }
            case 1: {
                nArray[0] = this.dim / 2 + n;
                nArray2[0] = 4 + n;
                nArray[1] = 4 + n;
                nArray2[1] = this.dim - 4 + n;
                nArray[2] = this.dim - 4 + n;
                nArray2[2] = this.dim - 4 + n;
                break;
            }
            case 2: {
                nArray[0] = this.dim - 4 + n;
                nArray2[0] = 4 + n;
                nArray[1] = this.dim - 4 + n;
                nArray2[1] = this.dim - 4 + n;
                nArray[2] = 4 + n;
                nArray2[2] = this.dim / 2 + n;
                break;
            }
            case 3: {
                nArray[0] = 4 + n;
                nArray2[0] = 4 + n;
                nArray[1] = this.dim - 4 + n;
                nArray2[1] = this.dim / 2 + n;
                nArray[2] = 4 + n;
                nArray2[2] = this.dim - 4 + n;
            }
        }
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    public boolean mouseDown(Event event, int n, int n2) {
        if (this.enabled) {
            this.upState = false;
            this.repaint();
        }
        return true;
    }

    public boolean mouseDrag(Event event, int n, int n2) {
        if (this.enabled) {
            boolean bl;
            Rectangle rectangle = this.bounds();
            boolean bl2 = bl = n >= 0 && n < rectangle.width && n2 >= 0 && n2 <= rectangle.height;
            if (this.upState == bl) {
                this.upState = !bl;
                this.repaint();
            }
        }
        return true;
    }

    public boolean mouseUp(Event event, int n, int n2) {
        if (this.enabled && !this.upState) {
            this.upState = true;
            this.repaint(0L);
            this.handleClick();
        }
        return true;
    }

    public boolean keyDown(Event event, int n) {
        return this.getParent().keyDown(event, n);
    }

    public void setKind(int n) {
        this.btnKind = n;
        this.repaint();
    }

    public int getKind() {
        return this.btnKind;
    }

    public void enable() {
        this.enabled = true;
        this.repaint();
    }

    public void disable() {
        this.enabled = false;
        this.repaint();
    }
}

