/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Graphics;
import java.io.PrintStream;
import lsedit.Diagram;
import lsedit.EdgePoint;
import lsedit.EntityClass;
import lsedit.EntityInstance;
import lsedit.Layout;
import lsedit.MsgOut;
import lsedit.RealPoint;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ScreenLayout;

public class BaseEntity
extends EntityInstance {
    protected static boolean has3Dlook = true;
    protected BaseEntity undoEntity;

    public static void set3Dlook(boolean bl) {
        has3Dlook = bl;
    }

    protected BaseEntity() {
    }

    public BaseEntity(EntityClass entityClass, String string, Diagram diagram) {
        super(entityClass, string, diagram);
        this.undoEntity = new BaseEntity();
    }

    public void saveForUndo() {
        super.saveForUndo(this.undoEntity);
    }

    public void undo() {
        BaseEntity baseEntity = this.undoEntity;
        this.undoEntity = new BaseEntity();
        this.doSaveForUndo(this.undoEntity);
        super.undo(baseEntity);
    }

    protected void setGraphicsColor(Graphics graphics) {
        if (this.highlightFlag && !this.isOpen()) {
            graphics.setColor(Color.red.darker());
        } else {
            graphics.setColor(this.getBackground());
        }
    }

    protected void clearFlagAttributes() {
        int n = (int)this.x();
        int n2 = (int)this.y();
        int n3 = (int)this.width();
        int n4 = (int)this.height();
        Graphics graphics = this.dg.ls.getDiagramContext();
        Color color = this.getBackground();
        graphics.setColor(color);
        int n5 = n4 < 20 ? 4 : 6;
        int n6 = n5 + 1;
        graphics.fillRect(n + 1, n2 + 1, n6, n6);
        graphics.fillRect(n + n3 / 2 - n5 / 2, n2 + 1, n6, n6);
        graphics.fillRect(n + n3 - n5, n2 + 1, n6, n6);
        graphics.fillRect(n + 1, n2 + n4 / 2 - n5 / 2, n6, n6);
        graphics.fillRect(n + n3 - n5, n2 + n4 / 2 - n5 / 2, n6, n6);
        graphics.fillRect(n + 1, n2 + n4 - n5, n6, n6);
        graphics.fillRect(n + n3 / 2 - n5 / 2, n2 + n4 - n5, n6, n6);
        graphics.fillRect(n + n3 - n5, n2 + n4 - n5, n6, n6);
        graphics.dispose();
    }

    protected void fillFlagAttributes(Graphics graphics, ScreenLayout screenLayout, Color color) {
        int n = screenLayout.x;
        int n2 = screenLayout.y;
        int n3 = screenLayout.width;
        int n4 = screenLayout.height;
        graphics.setColor(color);
        int n5 = n4 < 20 ? 4 : 6;
        graphics.fillRect(n + 1, n2 + 1, n5, n5);
        graphics.fillRect(n + n3 / 2 - n5 / 2, n2 + 1, n5, n5);
        graphics.fillRect(n + n3 - n5, n2 + 1, n5, n5);
        graphics.fillRect(n + 1, n2 + n4 / 2 - n5 / 2, n5, n5);
        graphics.fillRect(n + n3 - n5, n2 + n4 / 2 - n5 / 2, n5, n5);
        graphics.fillRect(n + 1, n2 + n4 - n5, n5, n5);
        graphics.fillRect(n + n3 / 2 - n5 / 2, n2 + n4 - n5, n5, n5);
        graphics.fillRect(n + n3 - n5, n2 + n4 - n5, n5, n5);
    }

    protected void outlineFlagAttributes(Graphics graphics, ScreenLayout screenLayout, Color color) {
        int n = screenLayout.x;
        int n2 = screenLayout.y;
        int n3 = screenLayout.width;
        int n4 = screenLayout.height;
        graphics.setColor(color);
        int n5 = n4 < 20 ? 4 : 6;
        graphics.drawRect(n + 1, n2 + 1, n5, n5);
        graphics.drawRect(n + n3 / 2 - n5 / 2, n2 + 1, n5, n5);
        graphics.drawRect(n + n3 - n5 - 1, n2 + 1, n5, n5);
        graphics.drawRect(n + 1, n2 + n4 / 2 - n5 / 2, n5, n5);
        graphics.drawRect(n + n3 - n5 - 1, n2 + n4 / 2 - n5 / 2, n5, n5);
        graphics.drawRect(n + 1, n2 + n4 - n5 - 1, n5, n5);
        graphics.drawRect(n + n3 / 2 - n5 / 2, n2 + n4 - n5 - 1, n5, n5);
        graphics.drawRect(n + n3 - n5 - 1, n2 + n4 - n5 - 1, n5, n5);
    }

    protected void clearGroupFlag() {
        if (this.getGroupFlag()) {
            super.clearGroupFlag();
            this.clearFlagAttributes();
        }
    }

    protected void drawFlagAttributes(Graphics graphics, ScreenLayout screenLayout) {
        if (this.getGroupFlag()) {
            if (this.getGroupKeyFlag()) {
                this.fillFlagAttributes(graphics, screenLayout, this.getLabelColor());
            } else {
                this.clearFlagAttributes();
                this.outlineFlagAttributes(graphics, screenLayout, this.getLabelColor());
            }
        }
    }

    protected void setGroupFlag() {
        super.setGroupFlag();
        ScreenLayout screenLayout = new ScreenLayout(this.x(), this.y(), this.width(), this.height());
        Graphics graphics = this.dg.ls.getDiagramContext();
        this.drawFlagAttributes(graphics, screenLayout);
        graphics.dispose();
    }

    public void draw(Graphics graphics) {
    }

    public RealPoint calculateIntercept(RealPoint realPoint, RealPoint realPoint2) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = this.y() - 1.0;
        double d4 = this.y() + this.height() + 1.0;
        double d5 = this.x() - 1.0;
        double d6 = this.x() + this.width() + 1.0;
        boolean bl = true;
        if (realPoint.x < d5 || realPoint.x > d6 || realPoint.y < d3 || realPoint.y > d4) {
            MsgOut.println("calculateIntercept: p1 is not in box");
            return new RealPoint(d, d2);
        }
        if (realPoint.x == realPoint2.x && realPoint.y == realPoint2.y) {
            MsgOut.println("calculateIntercept: p1 == p2");
            return new RealPoint(d, d2);
        }
        if (d6 <= realPoint2.x) {
            d = d6;
        } else if (realPoint2.x < d5) {
            d = d5;
        } else {
            bl = false;
        }
        if (bl) {
            d2 = realPoint.y + (d - realPoint.x) * ((realPoint2.y - realPoint.y) / (realPoint2.x - realPoint.x));
            boolean bl2 = bl = d3 <= d2 && d2 <= d4;
        }
        if (!bl) {
            bl = true;
            if (realPoint2.y <= d3) {
                d2 = d3;
            } else if (realPoint2.y >= d4) {
                d2 = d4;
            } else {
                bl = false;
            }
            if (bl) {
                d = realPoint.x + (d2 - realPoint.y) * ((realPoint2.x - realPoint.x) / (realPoint2.y - realPoint.y));
                boolean bl3 = bl = d5 <= d && d <= d6;
            }
        }
        if (!bl) {
            MsgOut.println("calculateIntercept failed: " + realPoint.x + " " + realPoint.y + " " + realPoint2.x + " " + realPoint2.y);
        }
        return new RealPoint(d, d2);
    }

    public boolean isPointOver(int n, int n2) {
        if (n < (int)this.x()) {
            return false;
        }
        if (n2 < (int)this.y()) {
            return false;
        }
        if (n > (int)(this.x() + this.width())) {
            return false;
        }
        return n2 <= (int)(this.y() + this.height());
    }

    public int overResizeTab(int n, int n2) {
        int n3;
        int n4 = (int)this.x();
        if (n < n4) {
            return -1;
        }
        if (n <= n4 + 6) {
            n3 = 0;
        } else {
            int n5 = (int)(this.x() + this.width());
            if (n > n5) {
                return -1;
            }
            if (n >= n5 - 6) {
                n3 = 2;
            } else {
                int n6 = (n4 + n5) / 2;
                if (n < n6 - 3 || n > n6 + 3) {
                    return -1;
                }
                n3 = 1;
            }
        }
        int n7 = (int)this.y();
        if (n2 < n7) {
            return -1;
        }
        if (n2 > n7 + 6) {
            int n8 = (int)(this.y() + this.height());
            if (n2 > n8) {
                return -1;
            }
            if (n2 >= n8 - 6) {
                n3 += 6;
            } else {
                int n9 = (n7 + n8) / 2;
                if (n2 < n9 - 3 || n2 > n9 + 3) {
                    return -1;
                }
                n3 += 3;
            }
        }
        switch (n3) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 7;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 5;
            }
            case 8: {
                return 4;
            }
        }
        return -1;
    }

    public boolean isPointOverIO(EdgePoint edgePoint, int n, int n2) {
        int n3 = (int)(edgePoint.x + 0.5);
        int n4 = (int)(edgePoint.y + 0.5);
        return n3 - 3 < n && n < n3 + 3 && n4 - 3 < n2 && n2 < n4 + 3;
    }

    public boolean containsLayout(Layout layout) {
        return this.x() < layout.x && layout.x + layout.width < this.x() + this.width() && this.y() < layout.y && layout.y + layout.height < this.y() + this.height();
    }

    public boolean intersectsLayout(Layout layout) {
        ScreenLayout screenLayout = new ScreenLayout(layout);
        ScreenLayout screenLayout2 = new ScreenLayout(this.x(), this.y(), this.width(), this.height());
        return screenLayout.intersects(screenLayout2);
    }

    public void drawHighlight(Graphics graphics) {
        graphics.setColor(Color.white);
        ScreenLayout screenLayout = new ScreenLayout(this.x(), this.y(), this.width(), this.height());
        graphics.drawRect(screenLayout.x, screenLayout.y, screenLayout.width, screenLayout.height);
        graphics.drawRect(screenLayout.x + 1, screenLayout.y + 1, screenLayout.width - 1, screenLayout.height - 1);
    }

    public void undrawHighlight(Graphics graphics) {
        this.setGraphicsColor(graphics);
        ScreenLayout screenLayout = new ScreenLayout(this.x(), this.y(), this.width(), this.height());
        graphics.draw3DRect(screenLayout.x, screenLayout.y, screenLayout.width, screenLayout.height, true);
        graphics.draw3DRect(screenLayout.x + 1, screenLayout.y + 1, screenLayout.width - 1, screenLayout.height - 1, true);
    }

    public void drawOutline(Graphics graphics, Layout layout) {
        ScreenLayout screenLayout = new ScreenLayout(layout);
        graphics.drawRect(screenLayout.x, screenLayout.y, screenLayout.width, screenLayout.height);
    }

    private EdgePoint getPoint(EdgePoint[] edgePointArray, RelationClass relationClass, int n) {
        int n2 = relationClass.getNid();
        EdgePoint edgePoint = edgePointArray[n2];
        if (edgePoint == null || edgePoint.getRc() != relationClass) {
            double d = relationClass.getIOfactor();
            double d2 = 0.0;
            double d3 = 0.0;
            switch (n) {
                case 0: {
                    d2 = d;
                    d3 = 0.0;
                    break;
                }
                case 1: {
                    d2 = d;
                    d3 = 1.0;
                    break;
                }
                case 2: {
                    d2 = 0.0;
                    d3 = d;
                    break;
                }
                default: {
                    d2 = 1.0;
                    d3 = d;
                }
            }
            if (edgePoint == null) {
                edgePointArray[n2] = edgePoint = new EdgePoint(this, relationClass, d2, d3);
            } else {
                edgePoint.setRc(relationClass);
            }
            edgePoint.rescale();
            edgePoint.isDefault = true;
            edgePoint.side = n;
        }
        return edgePoint;
    }

    public EdgePoint getPoint(RelationClass relationClass, int n) {
        EdgePoint[] edgePointArray;
        switch (n) {
            case 0: {
                edgePointArray = this.topPoints;
                if (edgePointArray != null) break;
                edgePointArray = new EdgePoint[this.dg.numRelationClasses()];
                this.topPoints = edgePointArray;
                break;
            }
            case 1: {
                edgePointArray = this.bottomPoints;
                if (edgePointArray != null) break;
                edgePointArray = new EdgePoint[this.dg.numRelationClasses()];
                this.bottomPoints = edgePointArray;
                break;
            }
            case 2: {
                edgePointArray = this.leftPoints;
                if (edgePointArray != null) break;
                edgePointArray = new EdgePoint[this.dg.numRelationClasses()];
                this.leftPoints = edgePointArray;
                break;
            }
            default: {
                edgePointArray = this.rightPoints;
                if (edgePointArray != null) break;
                edgePointArray = new EdgePoint[this.dg.numRelationClasses()];
                this.rightPoints = edgePointArray;
            }
        }
        return this.getPoint(edgePointArray, relationClass, n);
    }

    public EdgePoint getOutPoint(RelationInstance relationInstance, int n, Layout layout, Layout layout2) {
        RelationClass relationClass = relationInstance.getRelationClass();
        int n2 = relationClass.getNid();
        switch (n) {
            case 1: {
                BaseEntity baseEntity = (BaseEntity)relationInstance.getSrc();
                if (this == baseEntity || baseEntity.isContainedBy(this)) {
                    return this.getPoint(relationClass, 1);
                }
                return this.getPoint(relationClass, 0);
            }
        }
        if (layout2.y - (layout.y + layout.height) > 8.0) {
            return this.getPoint(relationClass, 1);
        }
        if (layout.y - (layout2.y + layout2.height) > 8.0) {
            return this.getPoint(relationClass, 0);
        }
        if (layout2.x - (layout.x + layout.width) > 8.0) {
            return this.getPoint(relationClass, 3);
        }
        if (layout.x - (layout2.x + layout2.width) > 8.0) {
            return this.getPoint(relationClass, 2);
        }
        if (layout2.y > layout.y + layout.height) {
            return this.getPoint(relationClass, 1);
        }
        return this.getPoint(relationClass, 0);
    }

    protected EdgePoint testMouseOverIO(EdgePoint[] edgePointArray, int n, int n2) {
        if (edgePointArray == null) {
            return null;
        }
        for (int i = 0; i < edgePointArray.length; ++i) {
            EdgePoint edgePoint = edgePointArray[i];
            if (edgePoint == null || !this.isPointOverIO(edgePoint, n, n2)) continue;
            return edgePoint;
        }
        return null;
    }

    public EdgePoint getMouseOverIO(int n, int n2) {
        EdgePoint edgePoint = this.testMouseOverIO(this.topPoints, n, n2);
        if (edgePoint != null) {
            return edgePoint;
        }
        edgePoint = this.testMouseOverIO(this.bottomPoints, n, n2);
        if (edgePoint != null) {
            return edgePoint;
        }
        edgePoint = this.testMouseOverIO(this.leftPoints, n, n2);
        if (edgePoint != null) {
            return edgePoint;
        }
        return this.testMouseOverIO(this.rightPoints, n, n2);
    }

    protected void writePoints(PrintStream printStream, EdgePoint[] edgePointArray, String string) {
        int n;
        if (edgePointArray == null) {
            return;
        }
        boolean bl = true;
        for (n = 1; n < edgePointArray.length; ++n) {
            if (edgePointArray[n] == null) continue;
            bl = bl && edgePointArray[n].isDefault;
        }
        if (bl) {
            return;
        }
        printStream.print("\t" + string + " = ( ");
        for (n = 1; n < edgePointArray.length; ++n) {
            if (edgePointArray[n] == null || edgePointArray[n].isDefault) continue;
            printStream.print("(" + edgePointArray[n].getRc().getId() + " " + edgePointArray[n].wf + " " + edgePointArray[n].hf + ") ");
        }
        printStream.print(")\n");
    }

    public void writeIOpoints(PrintStream printStream) {
        this.writePoints(printStream, this.topPoints, "inpoints");
        this.writePoints(printStream, this.bottomPoints, "outpoints");
        this.writePoints(printStream, this.leftPoints, "leftpoints");
        this.writePoints(printStream, this.rightPoints, "rightpoints");
    }
}

