/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.util.Enumeration;
import java.util.Vector;
import lsedit.EntityInstance;
import lsedit.RelationInstance;

public class Bend {
    public static final int SIZE = 6;
    public double x;
    public double y;
    public double xLocal;
    public double yLocal;
    public EntityInstance e;
    protected Vector edges = new Vector();

    public Bend(EntityInstance entityInstance, RelationInstance relationInstance, double d, double d2, boolean bl) {
        this.e = entityInstance;
        this.edges.addElement(relationInstance);
        if (bl) {
            this.x = d;
            this.y = d2;
        } else {
            this.xLocal = d;
            this.yLocal = d2;
        }
    }

    public Bend(EntityInstance entityInstance, RelationInstance relationInstance, double d, double d2) {
        this.e = entityInstance;
        this.edges.addElement(relationInstance);
        this.x = d;
        this.y = d2;
    }

    public Bend(EntityInstance entityInstance, RelationInstance relationInstance, int n, int n2) {
        this.e = entityInstance;
        this.edges.addElement(relationInstance);
        this.x = n;
        this.y = n2;
    }

    private Bend(EntityInstance entityInstance, double d, double d2) {
        this.e = entityInstance;
        this.x = d;
        this.y = d2;
    }

    public void delete() {
        this.e.deleteBend(this);
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.deleteBend(this);
        }
    }

    public void addRelation(RelationInstance relationInstance) {
        this.edges.addElement(relationInstance);
    }

    public boolean hasRelation(RelationInstance relationInstance) {
        return this.edges.contains(relationInstance);
    }

    public RelationInstance getFirstEdge() {
        return (RelationInstance)this.edges.firstElement();
    }

    public void move(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public boolean isOver(double d, double d2) {
        return d >= this.x - 3.0 && d < this.x + 3.0 && d2 >= this.y - 3.0 && d2 < this.y + 3.0;
    }

    public boolean isOver(int n, int n2) {
        return this.isOver((double)n, (double)n2);
    }

    public void translate(double d, double d2) {
        this.x += d;
        this.y += d2;
    }

    public Object clone() {
        Bend bend = new Bend(this.e, this.x, this.y);
        Enumeration enumeration = this.edges.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            bend.addRelation(relationInstance);
        }
        return bend;
    }
}

