/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Button;
import java.awt.Color;
import java.awt.Container;
import java.awt.Event;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JSlider;

public class ColorChooser
extends JDialog {
    private static JColorChooser m_tcc = null;
    private static JSlider m_slider = null;
    private Button m_okButton;
    private Button m_canButton;
    private Button m_nullButton;
    private static Color m_color;

    private ColorChooser(Frame frame, String string, Color color, boolean bl, boolean bl2) {
        super(frame, string, true);
        m_color = color;
        Container container = this.getContentPane();
        if (m_tcc == null) {
            m_tcc = new JColorChooser();
            m_slider = new JSlider(1, 255, 255);
            m_slider.setMajorTickSpacing(50);
            m_slider.setPaintLabels(true);
            m_slider.setPaintTicks(true);
        }
        m_tcc.setColor(color == null ? Color.gray : color);
        container.add("North", m_tcc);
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 15, 15));
        if (bl) {
            Panel panel2 = new Panel();
            m_slider.setValue(255);
            panel2.add("Top", m_slider);
            panel2.add("Bottom", new Label("Alpha", 1));
            container.add("Center", panel2);
        }
        this.m_okButton = new Button("OK");
        panel.add(this.m_okButton);
        if (!bl2) {
            this.m_nullButton = null;
        } else {
            this.m_nullButton = new Button("Null");
            panel.add(this.m_nullButton);
        }
        this.m_canButton = new Button("Cancel");
        panel.add(this.m_canButton);
        container.add("South", panel);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ColorChooser.this.dispose();
            }
        });
        this.pack();
    }

    public boolean action(Event event, Object object) {
        if (event.target != this.m_canButton) {
            if (event.target == this.m_okButton) {
                int n;
                m_color = m_tcc.getColor();
                if (m_slider != null && (n = m_slider.getValue()) != 255) {
                    m_color = new Color(m_color.getRed(), m_color.getGreen(), m_color.getBlue(), n);
                }
            } else if (event.target != null && event.target == this.m_nullButton) {
                m_color = null;
            } else {
                return false;
            }
        }
        this.dispose();
        return true;
    }

    public static Color create(Frame frame, String string, Color color, boolean bl, boolean bl2) {
        ColorChooser colorChooser = new ColorChooser(frame, string, color, bl, bl2);
        colorChooser.move(20, 20);
        colorChooser.show();
        return m_color;
    }
}

