/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import lsedit.Attribute;
import lsedit.AttributeRecord;
import lsedit.AttributeValueItem;
import lsedit.BaseEntity;
import lsedit.Bend;
import lsedit.ClientCompareFn;
import lsedit.DataInputStream;
import lsedit.DrawCache;
import lsedit.EdgePoint;
import lsedit.EditNewEntityDialog;
import lsedit.EntityClass;
import lsedit.EntityInfo;
import lsedit.EntityInstance;
import lsedit.InternalBufferStream;
import lsedit.LandscapeClassObject;
import lsedit.LandscapeObject;
import lsedit.LandscapeTokenStream;
import lsedit.LandscapeViewerCore;
import lsedit.Layout;
import lsedit.MsgOut;
import lsedit.OrderedHashTableEnumeration;
import lsedit.RelationClass;
import lsedit.RelationInstance;
import lsedit.ScreenLayout;
import lsedit.SupplierCompareFn;
import lsedit.Tuple;
import lsedit.Util;

public class Diagram
implements Runnable {
    public DrawCache drawCache;
    public static final float BG = 0.75f;
    public static final String BG_STR = "0.75";
    public static final Color boxColour = Color.lightGray;
    protected static final int EXIT_FLAG_DIM = 8;
    protected static final int GAP = 5;
    protected static final int MARGIN = 10;
    public static final String INSTANCE_ID = "$INSTANCE";
    public static final String INHERIT_RELN = "$INHERIT";
    public static final String ALL_RELN = "All";
    public static final String CONTAIN_ID = "contain";
    public static final String EDGEMODE_ID = "edgemode";
    public static final String TOPCLIENTS_ID = "topclients";
    public static final String WANTCLIENTS_ID = "wantclients";
    public static final String WANTSUPPLIERS_ID = "wantsuppliers";
    public static final String WANTCARDINALS_ID = "wantcardinals";
    public static final String SCALE_ID = "scale";
    public static final String RELN_HIDDEN_ID = "reln_hidden";
    public static final String NAVLINK_ID = "navlink";
    public static final String RAW_HEADER = "#TA_RAW#";
    public static final int STUMP_DST = 1;
    public static final int BEST_EDGE = 0;
    public static final int TB_EDGE = 1;
    public static final int DIRECT_EDGE = 2;
    public static final int UPDATE_FREQ = 250;
    public static final int DEF_CAP = 2000;
    public static final float DEF_LOAD = 0.5f;
    public static final int DEF_REL_CAP = 10000;
    protected static final int CLIENT = 1;
    protected static final int SUPPLIER = 2;
    protected static final String ROOT_ID = "$ROOT";
    protected static final double MIN_REL_SCALE = 0.1;
    protected static final double MAX_REL_SCALE = 10.0;
    protected static final int MOVE_ZONE_MAX = 20;
    protected static final double CLIENT_SUPPLIER_HEIGHT = 50.0;
    protected static final String EDGE_SUFFIX = "$EDGESUFFIX$";
    protected int x;
    protected int y;
    protected int width;
    protected int height;
    protected EntityInstance rootInstance;
    protected EntityInstance drawRoot;
    protected Hashtable entityClasses = new Hashtable(10);
    protected Hashtable relationClasses = new Hashtable(5);
    protected Hashtable entityInstances = new Hashtable(2000, 0.5f);
    protected Hashtable attrNames = new Hashtable(20);
    protected Hashtable edges = new Hashtable(10000, 0.5f);
    protected Vector numToRel = new Vector(10);
    protected ClientCompareFn clientCompareFn = new ClientCompareFn();
    protected SupplierCompareFn supplierCompareFn = new SupplierCompareFn();
    protected RelationClass relationBaseClass;
    protected EntityClass entityBaseClass;
    protected int numRelationClasses = 0;
    protected int numVisibleRelationClasses = 0;
    protected EntityClass defaultEntityClass = null;
    protected int numEntityClasses = 0;
    protected boolean persistentQuery = false;
    protected boolean universalScheme = false;
    protected boolean allowRecursion = true;
    protected boolean readOnly = false;
    protected LandscapeViewerCore ls;
    protected Object context;
    protected int mode;
    protected int gridPixels = 1;
    protected double xScale = 1.0;
    protected double yScale = 1.0;
    protected double topXscale;
    protected double topYscale;
    protected Attribute relVisibilityAttr;
    protected boolean visibleEdges = true;
    protected boolean drawEdges = true;
    protected boolean drawBends = false;
    protected Color xorMode = null;
    protected int newCnt = 0;
    protected Diagram undoDg;
    protected boolean undoValid = false;
    protected int xoffset;
    protected int yoffset;
    protected int timeStamp = 0;
    protected Vector sourceList;
    protected Vector sectionList;
    protected Vector globalBends = new Vector();
    protected EntityInstance keyEntity;
    protected boolean changedFlag = false;
    protected Vector clients;
    protected Vector suppliers;
    protected Vector dClients;
    protected Vector dSuppliers;
    protected boolean clientsSorted = false;
    protected boolean suppliersSorted = false;
    protected boolean allClients = true;
    protected boolean allSuppliers = true;
    protected int progressCount;
    private boolean schemeSetup = false;
    private String resString = null;
    protected static final String[] rootAttributes = new String[]{"scale", "reln_hidden", "edgemode", "navlink", "topclients", "wantclients", "wantsuppliers", "wantcardinals"};
    protected Vector bgpaths;

    protected boolean isTopClients() {
        return this.ls.getOption(1107);
    }

    protected double calcWidth(Graphics graphics, Vector vector, int n) {
        Enumeration enumeration = vector.elements();
        double d = 0.0;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if ((entityInstance.getMark() & n) != 0) continue;
            Layout layout = entityInstance.getLayout();
            Dimension dimension = entityInstance.getFitDim(graphics, 0, true);
            d += (double)(dimension.width + 5);
        }
        return d;
    }

    protected EntityInstance mostFrequentParent(Vector vector, int n) {
        int n2;
        Vector<EntityInstance> vector2 = new Vector<EntityInstance>();
        int[] nArray = new int[vector.size()];
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance;
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if ((entityInstance2.getMark() & n) != 0 || (entityInstance = entityInstance2.getEnterableParent()).descendent(this.drawRoot)) continue;
            n2 = vector2.indexOf(entityInstance);
            if (n2 < 0) {
                nArray[vector2.size()] = 1;
                vector2.addElement(entityInstance);
                continue;
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
        }
        int n4 = 0;
        int n5 = -1;
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            if (nArray[n2] <= n4) continue;
            n4 = nArray[n2];
            n5 = n2;
        }
        if (n5 < 0) {
            return null;
        }
        return (EntityInstance)vector2.elementAt(n5);
    }

    protected void markEntities() {
        EntityInstance entityInstance;
        Enumeration enumeration = this.clients.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.setMark(entityInstance.getMark() | 1);
        }
        enumeration = this.suppliers.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance.setMark(entityInstance.getMark() | 2);
        }
    }

    protected void elimDescendents(Vector vector, EntityInstance entityInstance) {
        EntityInstance entityInstance2;
        Vector<EntityInstance> vector2 = new Vector<EntityInstance>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (!entityInstance.descendent(entityInstance2)) continue;
            vector2.addElement(entityInstance2);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance2 = (EntityInstance)enumeration.nextElement();
            vector.removeElement(entityInstance2);
        }
    }

    protected void elimAmbiguities() {
        EntityInstance entityInstance;
        this.markEntities();
        Enumeration enumeration = this.clients.elements();
        Vector<EntityInstance> vector = new Vector<EntityInstance>();
        Vector<EntityInstance> vector2 = new Vector<EntityInstance>();
        Vector<EntityInstance> vector3 = new Vector<EntityInstance>();
        Vector<EntityInstance> vector4 = new Vector<EntityInstance>();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            Enumeration enumeration2 = this.suppliers.elements();
            while (enumeration2.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration2.nextElement();
                if (entityInstance2 != entityInstance && entityInstance2.descendent(entityInstance)) {
                    vector.addElement(entityInstance);
                    if (vector3.contains(entityInstance2)) continue;
                    vector3.addElement(entityInstance2);
                    continue;
                }
                if (entityInstance2 == entityInstance || !entityInstance.descendent(entityInstance2)) continue;
                vector2.addElement(entityInstance);
                if (vector4.contains(entityInstance)) continue;
                vector4.addElement(entityInstance);
            }
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            this.clients.removeElement(entityInstance);
        }
        enumeration = vector3.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            this.elimDescendents(this.clients, entityInstance);
            this.clients.addElement(entityInstance);
        }
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            this.suppliers.removeElement(entityInstance);
        }
        enumeration = vector4.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            this.elimDescendents(this.suppliers, entityInstance);
            this.suppliers.addElement(entityInstance);
        }
        this.markEntities();
    }

    protected Vector getDisplaySet(Vector vector, int n) {
        if (vector == null) {
            return null;
        }
        Vector<EntityInstance> vector2 = new Vector<EntityInstance>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if ((entityInstance.getMark() & n) != 0) continue;
            vector2.addElement(entityInstance);
        }
        return vector2;
    }

    protected boolean reduceClientSuppliers(Graphics graphics, Vector vector, int n) {
        EntityInstance entityInstance;
        double d;
        boolean bl = true;
        while (!((d = this.calcWidth(graphics, vector, n)) <= (double)(this.width - 20)) && (entityInstance = this.mostFrequentParent(vector, n)) != null) {
            this.elimDescendents(vector, entityInstance);
            vector.addElement(entityInstance);
        }
        return bl;
    }

    protected void output(String string, Vector vector) {
        System.out.println(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            System.out.println(" " + entityInstance);
        }
    }

    protected void findClientsAndSuppliers() {
        this.clients = new Vector();
        this.suppliers = new Vector();
        if (this.ls.getOption(1104)) {
            this.drawRoot.getClients(this.clients, this.drawRoot);
        }
        if (this.ls.getOption(1105)) {
            this.drawRoot.getSuppliers(this.suppliers, this.drawRoot);
        }
        Graphics graphics = this.ls.getGraphics();
        this.rootInstance.clearMarks();
        this.allSuppliers = this.reduceClientSuppliers(graphics, this.suppliers, 0);
        this.markEntities();
        this.allClients = this.reduceClientSuppliers(graphics, this.clients, 2);
        this.markEntities();
        this.elimAmbiguities();
        this.markEntities();
        this.dClients = this.getDisplaySet(this.clients, 2);
        this.dSuppliers = this.getDisplaySet(this.suppliers, 0);
    }

    protected double getClientSupplierPos(double d, double d2) {
        return this.isTopClients() ? d : d2;
    }

    protected void updateProgress() {
        ++this.progressCount;
        StringBuffer stringBuffer = new StringBuffer("Loading: ");
        for (int i = 0; i < this.progressCount; ++i) {
            stringBuffer.append('*');
        }
        this.ls.doFeedback(new String(stringBuffer));
    }

    protected void setVisibilityFlags() {
        Enumeration enumeration = this.enumRelations();
        this.numVisibleRelationClasses = 0;
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (this.excludeReln(relationClass) || !relationClass.isVisible()) continue;
            relationClass.setOrdinal(this.numVisibleRelationClasses++);
        }
        this.visibleEdges = this.numVisibleRelationClasses > 0;
    }

    protected void registerAttrName(String string) {
        if (this.attrNames.get(string) == null) {
            this.attrNames.put(string, string);
        }
    }

    protected void registerAttrNames(Attribute attribute) {
        while (attribute != null) {
            this.registerAttrName(attribute.id);
            attribute = attribute.next;
        }
    }

    protected RelationClass addRelationClass(String string) {
        RelationClass relationClass = (RelationClass)this.relationClasses.get(string);
        if (relationClass == null) {
            relationClass = new RelationClass(string, this.numRelationClasses, this.relationBaseClass, this);
            this.relationClasses.put(string, relationClass);
            this.numToRel.addElement(relationClass);
            ++this.numRelationClasses;
        }
        return relationClass;
    }

    protected EntityClass addEntityClass(String string) {
        EntityClass entityClass = (EntityClass)this.entityClasses.get(string);
        if (entityClass == null) {
            entityClass = new EntityClass(string, this.numEntityClasses++, this.entityBaseClass, this);
            this.entityClasses.put(string, entityClass);
            if (this.defaultEntityClass == null) {
                this.defaultEntityClass = entityClass;
            }
        }
        return entityClass;
    }

    protected EntityInstance addEntity(EntityClass entityClass, String string) {
        EntityInstance entityInstance = entityClass.newEntity(string, this);
        entityInstance.setNid(this.entityInstances.size());
        this.entityInstances.put(string, entityInstance);
        this.rootInstance.addContainment(entityInstance);
        return entityInstance;
    }

    protected void removeEntity(EntityInstance entityInstance) {
        entityInstance.getParent().removeContainment(entityInstance);
        this.entityInstances.remove(entityInstance.getId());
    }

    protected boolean containsEntity(EntityInstance entityInstance) {
        return this.entityInstances.contains(entityInstance.getId());
    }

    protected void setupUniversalScheme() {
        this.relationBaseClass.addRelation(this.entityBaseClass, this.entityBaseClass);
        this.universalScheme = true;
    }

    protected void processSchemeTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        Tuple tuple;
        while ((tuple = landscapeTokenStream.nextTuple()) != null) {
            RelationClass relationClass = null;
            boolean bl = tuple.token1.equals(INHERIT_RELN);
            if (bl) {
                if (tuple.token2.equals("$ENTITY")) {
                    landscapeTokenStream.errorNS("Improper use of $ENTITY with $INHERIT");
                    return;
                }
            } else {
                relationClass = this.addRelationClass(tuple.token1);
            }
            EntityClass entityClass = this.addEntityClass(tuple.token2);
            EntityClass entityClass2 = this.addEntityClass(tuple.token3);
            if (bl) {
                String string = entityClass.addParentClass(entityClass2);
                if (string == null) continue;
                landscapeTokenStream.errorNS(string);
                continue;
            }
            relationClass.addRelation(entityClass, entityClass2);
        }
        return;
    }

    protected void processSchemeAttributes(LandscapeTokenStream landscapeTokenStream) throws IOException {
        AttributeRecord attributeRecord;
        while ((attributeRecord = landscapeTokenStream.nextRecord()) != null) {
            Object object;
            Object object2;
            if (attributeRecord.id.startsWith("(")) {
                object2 = new StringTokenizer(attributeRecord.id, "() ");
                object = ((StringTokenizer)object2).nextToken();
                RelationClass relationClass = (RelationClass)this.relationClasses.get(object);
                if (relationClass != null) {
                    Attribute attribute = attributeRecord.attributes;
                    while (attribute != null) {
                        relationClass.addAttribute(attribute);
                        attribute = attribute.next;
                    }
                    this.registerAttrNames(attributeRecord.attributes);
                    continue;
                }
                landscapeTokenStream.errorNS("Can't process record. Missing relation class '" + (String)object + "'");
                continue;
            }
            if (attributeRecord.id.equals(ROOT_ID)) {
                object2 = attributeRecord.attributes;
                while (object2 != null) {
                    this.rootInstance.addAttribute((Attribute)object2);
                    object2 = ((Attribute)object2).next;
                }
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            object2 = (EntityClass)this.entityClasses.get(attributeRecord.id);
            if (object2 != null) {
                object = attributeRecord.attributes;
                while (object != null) {
                    ((LandscapeClassObject)object2).addAttribute((Attribute)object);
                    object = ((Attribute)object).next;
                }
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            landscapeTokenStream.errorNS("Can't process record. Missing entity class '" + attributeRecord.id + "'");
        }
        return;
    }

    protected void processFactTuples(LandscapeTokenStream landscapeTokenStream) throws IOException {
        int n = 0;
        int n2 = 0;
        MsgOut.vprint("\nFACT TUPLE : ");
        Tuple tuple;
        while ((tuple = landscapeTokenStream.nextTuple()) != null) {
            EntityClass entityClass;
            LandscapeObject landscapeObject;
            LandscapeObject landscapeObject2;
            if (tuple.token1.equals(INSTANCE_ID)) {
                if (++n % 250 == 0) {
                    MsgOut.vprint(".");
                    this.updateProgress();
                    this.ls.showInfo("Entities: " + n);
                }
                if ((landscapeObject2 = (EntityInstance)this.entityInstances.get(tuple.token2)) == null) {
                    landscapeObject = (EntityClass)this.entityClasses.get(tuple.token3);
                    if (landscapeObject != null) {
                        landscapeObject2 = ((EntityClass)landscapeObject).newEntity(tuple.token2, this);
                        landscapeObject2.setNid(this.entityInstances.size());
                        this.entityInstances.put(tuple.token2, landscapeObject2);
                        this.rootInstance.addContainment((EntityInstance)landscapeObject2);
                        continue;
                    }
                    landscapeTokenStream.errorNS("EntityClass '" + tuple.token3 + "' has not been declared");
                    continue;
                }
                landscapeObject = ((EntityInstance)landscapeObject2).getEntityClass();
                if (((EntityClass)landscapeObject).hasId(tuple.token3)) {
                    landscapeTokenStream.warning("Redeclaration of " + ((EntityInstance)landscapeObject2).toString());
                    continue;
                }
                landscapeTokenStream.errorNS("Attempt to declare " + landscapeObject2.getId() + " as instanceof " + tuple.token3 + ". Currently declared as instanceof " + landscapeObject.getId());
                continue;
            }
            if (++n2 % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgress();
                this.ls.showInfo("Relations: " + n2);
            }
            landscapeObject2 = (RelationClass)this.relationClasses.get(tuple.token1);
            landscapeObject = (EntityInstance)this.entityInstances.get(tuple.token2);
            EntityInstance entityInstance = (EntityInstance)this.entityInstances.get(tuple.token3);
            if (this.universalScheme) {
                if (landscapeObject2 == null) {
                    landscapeObject2 = this.relationBaseClass;
                }
                if (landscapeObject == null) {
                    landscapeObject = this.entityBaseClass.newEntity(tuple.token2, this);
                    landscapeObject.setNid(this.entityInstances.size());
                    this.entityInstances.put(tuple.token2, landscapeObject);
                    this.rootInstance.addContainment((EntityInstance)landscapeObject);
                }
                if (entityInstance == null) {
                    entityInstance = this.entityBaseClass.newEntity(tuple.token3, this);
                    entityInstance.setNid(this.entityInstances.size());
                    this.entityInstances.put(tuple.token3, entityInstance);
                    this.rootInstance.addContainment(entityInstance);
                }
            }
            if (landscapeObject2 == null) {
                landscapeTokenStream.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token1 + "'");
                continue;
            }
            if (landscapeObject == null) {
                landscapeTokenStream.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token2 + "'");
                continue;
            }
            if (entityInstance == null) {
                landscapeTokenStream.errorNS("Can't process: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ") - Missing '" + tuple.token3 + "'");
                continue;
            }
            if (!this.allowRecursion && landscapeObject == entityInstance) {
                landscapeTokenStream.warning("Ignoring recursive relation: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ")");
                continue;
            }
            if (((EntityInstance)landscapeObject).isContainedBy(entityInstance)) {
                landscapeTokenStream.errorNS("Relation from child to containing parent: (" + tuple.token1 + " " + tuple.token2 + " " + tuple.token3 + ")");
                continue;
            }
            EntityClass entityClass2 = ((EntityInstance)landscapeObject).getEntityClass();
            if (((RelationClass)landscapeObject2).isValidRelation(entityClass2, entityClass = entityInstance.getEntityClass())) {
                if (tuple.token1.equals(CONTAIN_ID)) {
                    if (!this.rootInstance.removeContainment(entityInstance)) continue;
                    ((EntityInstance)landscapeObject).addContainment(entityInstance);
                    continue;
                }
                this.addEdge((EntityInstance)landscapeObject, entityInstance, (RelationClass)landscapeObject2);
                continue;
            }
            landscapeTokenStream.errorNS("Invalid use of relation " + tuple.token1);
        }
        return;
    }

    protected void processFactAttributes(LandscapeTokenStream landscapeTokenStream) throws IOException {
        AttributeRecord attributeRecord;
        int n = 0;
        MsgOut.vprint("\nFACT ATTRIBUTE : ");
        while ((attributeRecord = landscapeTokenStream.nextRecord()) != null) {
            Object object;
            if (++n % 250 == 0) {
                MsgOut.vprint(".");
                this.updateProgress();
                this.ls.showInfo("Attr Records: " + n);
            }
            MsgOut.vprintln("Processing record: " + attributeRecord.id);
            if (attributeRecord.id.startsWith("(")) {
                object = new Tuple(attributeRecord.id);
                RelationClass relationClass = (RelationClass)this.relationClasses.get(((Tuple)object).token1);
                EntityInstance entityInstance = (EntityInstance)this.entityInstances.get(((Tuple)object).token2);
                EntityInstance entityInstance2 = (EntityInstance)this.entityInstances.get(((Tuple)object).token3);
                if (relationClass == null) {
                    landscapeTokenStream.errorNS("Can't process record for " + attributeRecord.id + ". " + "Missing relation '" + ((Tuple)object).token1 + "'");
                    continue;
                }
                if (entityInstance == null) {
                    landscapeTokenStream.errorNS("Can't process record for " + attributeRecord.id + ". " + "Missing entity '" + ((Tuple)object).token2 + "'");
                    continue;
                }
                if (entityInstance2 == null) {
                    landscapeTokenStream.errorNS("Can't process record for " + attributeRecord.id + ". " + "Missing entity '" + ((Tuple)object).token3 + "'");
                    continue;
                }
                RelationInstance relationInstance = entityInstance.getRelation(relationClass, entityInstance2);
                if (relationInstance == null) {
                    landscapeTokenStream.errorNS("Can't process record. Missing relation " + attributeRecord.id);
                    continue;
                }
                relationInstance.assignAttributes(attributeRecord.attributes, this.entityInstances);
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            object = attributeRecord.id.equals(ROOT_ID) ? this.rootInstance : (EntityInstance)this.entityInstances.get(attributeRecord.id);
            if (object != null) {
                ((EntityInstance)object).assignAttributes(attributeRecord.attributes);
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            if (this.universalScheme) {
                object = this.entityBaseClass.newEntity(attributeRecord.id, this);
                ((LandscapeObject)object).setNid(this.entityInstances.size());
                this.entityInstances.put(attributeRecord.id, object);
                this.rootInstance.addContainment((EntityInstance)object);
                ((EntityInstance)object).assignAttributes(attributeRecord.attributes);
                this.registerAttrNames(attributeRecord.attributes);
                continue;
            }
            landscapeTokenStream.errorNS("Can't process record. Missing entity '" + attributeRecord.id + "'");
        }
    }

    protected void writeRawPairs(DataOutputStream dataOutputStream, Vector vector) throws IOException {
        dataOutputStream.writeInt(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Integer[] integerArray = (Integer[])enumeration.nextElement();
            dataOutputStream.writeInt(integerArray[0]);
            dataOutputStream.writeInt(integerArray[1]);
        }
    }

    protected void writeRawTriples(DataOutputStream dataOutputStream, Vector vector) throws IOException {
        dataOutputStream.writeInt(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Integer[] integerArray = (Integer[])enumeration.nextElement();
            dataOutputStream.writeInt(integerArray[0]);
            dataOutputStream.writeInt(integerArray[1]);
            dataOutputStream.writeInt(integerArray[2]);
        }
    }

    protected void writeRawAttributes(DataOutputStream dataOutputStream, Vector vector) throws IOException {
        dataOutputStream.writeInt(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object[] objectArray = (Object[])enumeration.nextElement();
            dataOutputStream.writeInt((Integer)objectArray[0]);
            Vector vector2 = (Vector)objectArray[1];
            dataOutputStream.writeInt(vector2.size());
            Enumeration enumeration2 = vector2.elements();
            block10: while (enumeration2.hasMoreElements()) {
                Object[] objectArray2 = (Object[])enumeration2.nextElement();
                dataOutputStream.writeInt((Integer)objectArray2[0]);
                int n = (Integer)objectArray2[1];
                dataOutputStream.writeInt(n);
                switch (n) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        dataOutputStream.writeInt((Integer)objectArray2[2]);
                        break;
                    }
                    case 2: {
                        dataOutputStream.writeDouble((Double)objectArray2[2]);
                        break;
                    }
                    case 3: {
                        dataOutputStream.writeUTF((String)objectArray2[2]);
                        break;
                    }
                    case 4: {
                        int n2;
                        Object[] objectArray3 = (int[])objectArray2[2];
                        int n3 = objectArray3.length;
                        dataOutputStream.writeInt(n3);
                        for (n2 = 0; n2 < n3; ++n2) {
                            dataOutputStream.writeInt(objectArray3[n2]);
                        }
                        continue block10;
                    }
                    case 5: {
                        int n2;
                        Object[] objectArray3 = (double[])objectArray2[2];
                        int n3 = objectArray3.length;
                        dataOutputStream.writeInt(n3);
                        for (n2 = 0; n2 < n3; ++n2) {
                            dataOutputStream.writeDouble(objectArray3[n2]);
                        }
                        continue block10;
                    }
                    case 6: {
                        int n2;
                        Object[] objectArray3 = (String[])objectArray2[2];
                        int n3 = objectArray3.length;
                        dataOutputStream.writeInt(n3);
                        for (n2 = 0; n2 < n3; ++n2) {
                            dataOutputStream.writeUTF((String)objectArray3[n2]);
                        }
                        break;
                    }
                }
            }
        }
    }

    protected void writeSchemeTuples(PrintStream printStream) throws IOException {
        LandscapeClassObject landscapeClassObject;
        printStream.print("// Landscape TA file\n\n");
        printStream.print("SCHEME TUPLE :\n\n// The ERD\n\n");
        Enumeration enumeration = this.enumEntityClasses();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            if (landscapeClassObject == this.entityBaseClass) continue;
            Enumeration enumeration2 = landscapeClassObject.getParentElements();
            while (enumeration2.hasMoreElements()) {
                EntityClass entityClass = (EntityClass)enumeration2.nextElement();
                if (entityClass == this.entityBaseClass) continue;
                printStream.print("$INHERIT " + landscapeClassObject.getId() + " " + entityClass.getId() + "\n");
            }
        }
        printStream.print("\n");
        enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            ((RelationClass)landscapeClassObject).writeRelations(printStream);
        }
    }

    protected void writeSchemeTuplesRaw(DataOutputStream dataOutputStream, Hashtable hashtable) throws IOException {
        LandscapeClassObject landscapeClassObject;
        dataOutputStream.writeUTF("#1#");
        Vector<Integer[]> vector = new Vector<Integer[]>();
        Enumeration enumeration = this.enumEntityClasses();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            if (landscapeClassObject == this.entityBaseClass) continue;
            Enumeration enumeration2 = landscapeClassObject.getParentElements();
            while (enumeration2.hasMoreElements()) {
                EntityClass entityClass = (EntityClass)enumeration2.nextElement();
                if (entityClass == this.entityBaseClass) continue;
                Integer[] integerArray = new Integer[]{(Integer)hashtable.get(landscapeClassObject.getId()), (Integer)hashtable.get(entityClass.getId())};
                vector.addElement(integerArray);
            }
        }
        this.writeRawPairs(dataOutputStream, vector);
        vector = new Vector();
        enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            ((RelationClass)landscapeClassObject).getRelationsRaw(vector, hashtable);
        }
        this.writeRawTriples(dataOutputStream, vector);
    }

    protected void writeFactTuples(PrintStream printStream) throws IOException {
        printStream.print("\n\nFACT TUPLE :\n\n");
        printStream.print("// Instances of entity classes\n\n");
        this.rootInstance.writeInstances(printStream);
        this.rootInstance.writeRelations(printStream);
    }

    protected void writeFactTuplesRaw(DataOutputStream dataOutputStream, Hashtable hashtable) throws IOException {
        dataOutputStream.writeUTF("#3#");
        Vector vector = new Vector();
        this.rootInstance.getInstancesRaw(vector, hashtable);
        this.writeRawPairs(dataOutputStream, vector);
        vector = new Vector();
        this.rootInstance.getRelationsRaw(vector, hashtable, (Integer)hashtable.get(CONTAIN_ID));
        this.writeRawTriples(dataOutputStream, vector);
    }

    protected void writeSchemeAttributes(PrintStream printStream) throws IOException {
        LandscapeClassObject landscapeClassObject;
        printStream.print("\n\nSCHEME ATTRIBUTE :\n\n");
        printStream.print("// EntityClass attributes\n\n");
        Enumeration enumeration = this.entityClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            ((EntityClass)landscapeClassObject).writeAttributes(printStream);
        }
        enumeration = this.relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            ((RelationClass)landscapeClassObject).writeAttributes(printStream);
        }
    }

    protected void writeSchemeAttributesRaw(DataOutputStream dataOutputStream, Hashtable hashtable) throws IOException {
        LandscapeClassObject landscapeClassObject;
        dataOutputStream.writeUTF("#2#");
        Vector vector = new Vector();
        Enumeration enumeration = this.entityClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (EntityClass)enumeration.nextElement();
            landscapeClassObject.getAttributesRaw(vector, hashtable);
        }
        this.writeRawAttributes(dataOutputStream, vector);
        vector = new Vector();
        enumeration = this.relationClasses.elements();
        while (enumeration.hasMoreElements()) {
            landscapeClassObject = (RelationClass)enumeration.nextElement();
            landscapeClassObject.getAttributesRaw(vector, hashtable);
        }
        this.writeRawAttributes(dataOutputStream, vector);
    }

    protected void writeFactAttributes(PrintStream printStream) throws IOException {
        printStream.print("\n\nFACT ATTRIBUTE :\n\n");
        this.rootInstance.writeAttributes(printStream, true);
    }

    protected void writeFactAttributesRaw(DataOutputStream dataOutputStream, Hashtable hashtable) throws IOException {
        dataOutputStream.writeUTF("#4#");
        Vector vector = new Vector();
        this.rootInstance.getAttributesRaw(vector, hashtable);
        this.writeRawAttributes(dataOutputStream, vector);
    }

    protected Vector readStringTable(DataInputStream dataInputStream) throws IOException {
        Vector<String> vector = new Vector<String>();
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            vector.addElement(dataInputStream.readUTF());
        }
        return vector;
    }

    protected void processRawSchemeTuples(DataInputStream dataInputStream, Vector vector) throws IOException {
        LandscapeClassObject landscapeClassObject;
        Object object;
        String string;
        String string2;
        int n;
        int n2 = dataInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            string2 = (String)vector.elementAt(dataInputStream.readInt());
            string = (String)vector.elementAt(dataInputStream.readInt());
            object = this.addEntityClass(string2);
            landscapeClassObject = this.addEntityClass(string);
            ((EntityClass)object).addParentClass((EntityClass)landscapeClassObject);
        }
        n2 = dataInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            string2 = (String)vector.elementAt(dataInputStream.readInt());
            string = (String)vector.elementAt(dataInputStream.readInt());
            object = (String)vector.elementAt(dataInputStream.readInt());
            landscapeClassObject = this.addRelationClass(string2);
            EntityClass entityClass = this.addEntityClass(string);
            EntityClass entityClass2 = this.addEntityClass((String)object);
            ((RelationClass)landscapeClassObject).addRelation(entityClass, entityClass2);
        }
    }

    protected void processRawAttributes(LandscapeObject landscapeObject, DataInputStream dataInputStream, Vector vector) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            boolean bl;
            String string = (String)vector.elementAt(dataInputStream.readInt());
            int n2 = dataInputStream.readInt();
            this.registerAttrName(string);
            switch (n2) {
                case 0: {
                    bl = landscapeObject.addRawAttribute(string);
                    break;
                }
                case 1: {
                    bl = landscapeObject.addRawAttribute(string, dataInputStream.readInt());
                    break;
                }
                case 2: {
                    bl = landscapeObject.addRawAttribute(string, dataInputStream.readDouble());
                    break;
                }
                case 3: {
                    bl = landscapeObject.addRawAttribute(string, dataInputStream.readUTF());
                    break;
                }
                case 4: {
                    int n3;
                    int n4 = dataInputStream.readInt();
                    Object[] objectArray = new int[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        objectArray[n3] = dataInputStream.readInt();
                    }
                    bl = landscapeObject.addRawAttribute(string, (int[])objectArray);
                    break;
                }
                case 5: {
                    int n3;
                    int n4 = dataInputStream.readInt();
                    Object[] objectArray = new double[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        objectArray[n3] = (int)dataInputStream.readDouble();
                    }
                    bl = landscapeObject.addRawAttribute(string, (double[])objectArray);
                    break;
                }
                case 6: {
                    int n3;
                    int n4 = dataInputStream.readInt();
                    Object[] objectArray = new String[n4];
                    for (n3 = 0; n3 < n4; ++n3) {
                        objectArray[n3] = (int)dataInputStream.readUTF();
                    }
                    bl = landscapeObject.addRawAttribute(string, (String[])objectArray);
                    break;
                }
                default: {
                    bl = false;
                    MsgOut.println("Unknown attribute type: " + n2);
                }
            }
            if (bl) continue;
            MsgOut.println("Unhandled attribute: " + string + " - type: " + n2);
        }
    }

    protected void processRawSchemeAttributes(DataInputStream dataInputStream, Vector vector) throws IOException {
        LandscapeClassObject landscapeClassObject;
        String string;
        int n;
        int n2 = dataInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            string = (String)vector.elementAt(dataInputStream.readInt());
            landscapeClassObject = (EntityClass)this.entityClasses.get(string);
            this.processRawAttributes(landscapeClassObject, dataInputStream, vector);
        }
        n2 = dataInputStream.readInt();
        for (n = 0; n < n2; ++n) {
            string = (String)vector.elementAt(dataInputStream.readInt());
            landscapeClassObject = (RelationClass)this.relationClasses.get(string);
            this.processRawAttributes(landscapeClassObject, dataInputStream, vector);
        }
    }

    protected void processRawFactTuples(DataInputStream dataInputStream, Vector vector) throws IOException {
        Object object;
        int n;
        Object object2;
        int n2 = dataInputStream.readInt();
        EntityClass entityClass = null;
        int n3 = -1;
        for (int i = 0; i < n2; ++i) {
            object2 = (String)vector.elementAt(dataInputStream.readInt());
            n = dataInputStream.readInt();
            if (n != n3) {
                object = (String)vector.elementAt(n);
                entityClass = (EntityClass)this.entityClasses.get(object);
                n3 = n;
            }
            this.addEntity(entityClass, (String)object2);
            if (i % 250 != 0) continue;
            MsgOut.vprint(".");
            this.updateProgress();
            this.ls.showInfo("Entities: " + i);
        }
        n2 = dataInputStream.readInt();
        RelationClass relationClass = (RelationClass)this.relationClasses.get(CONTAIN_ID);
        object2 = null;
        n = -1;
        object = null;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            String string;
            int n5 = dataInputStream.readInt();
            int n6 = dataInputStream.readInt();
            if (n5 != n) {
                string = (String)vector.elementAt(n5);
                object2 = (RelationClass)this.relationClasses.get(string);
                n = n5;
            }
            if (n6 != n4) {
                string = (String)vector.elementAt(n6);
                object = (EntityInstance)this.entityInstances.get(string);
                n4 = n6;
            }
            string = (String)vector.elementAt(dataInputStream.readInt());
            EntityInstance entityInstance = (EntityInstance)this.entityInstances.get(string);
            if (object2 == relationClass) {
                if (this.rootInstance.removeContainment(entityInstance)) {
                    ((EntityInstance)object).addContainment(entityInstance);
                }
            } else {
                this.addEdge((EntityInstance)object, entityInstance, (RelationClass)object2);
            }
            if (i % 250 != 0) continue;
            MsgOut.vprint(".");
            this.updateProgress();
            this.ls.showInfo("Relations: " + i);
        }
    }

    protected void processRawFactAttributes(DataInputStream dataInputStream, Vector vector) throws IOException {
        int n = dataInputStream.readInt();
        for (int i = 0; i < n; ++i) {
            String string = (String)vector.elementAt(dataInputStream.readInt());
            EntityInstance entityInstance = (EntityInstance)this.entityInstances.get(string);
            this.processRawAttributes(entityInstance, dataInputStream, vector);
            if (i % 250 != 0) continue;
            MsgOut.vprint(".");
            this.updateProgress();
            this.ls.showInfo("Attr records: " + i);
        }
    }

    protected void parseRawStream(DataInputStream dataInputStream, String string, URL uRL) {
        try {
            String string2 = dataInputStream.readUTF();
            if (string2.equals(RAW_HEADER)) {
                String string3;
                Vector vector = this.readStringTable(dataInputStream);
                while (!(string3 = dataInputStream.readUTF()).equals("#END#")) {
                    if (string3.equals("#1#")) {
                        this.processRawSchemeTuples(dataInputStream, vector);
                        continue;
                    }
                    if (string3.equals("#2#")) {
                        this.processRawSchemeAttributes(dataInputStream, vector);
                        continue;
                    }
                    if (string3.equals("#3#")) {
                        this.processRawFactTuples(dataInputStream, vector);
                        continue;
                    }
                    if (string3.equals("#4#")) {
                        this.processRawFactAttributes(dataInputStream, vector);
                        continue;
                    }
                    MsgOut.println(string + "- Bad section: " + string3);
                }
            } else {
                this.resString = "Not a raw TA file";
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
            this.resString = exception.toString();
        }
    }

    protected boolean isRaw(BufferedInputStream bufferedInputStream) throws IOException {
        bufferedInputStream.mark(100);
        bufferedInputStream.read();
        bufferedInputStream.read();
        for (int i = 0; i < RAW_HEADER.length(); ++i) {
            int n = bufferedInputStream.read();
            if (n == RAW_HEADER.charAt(i)) continue;
            bufferedInputStream.reset();
            return false;
        }
        bufferedInputStream.reset();
        return true;
    }

    protected void parseStream(InputStream inputStream, String string, URL uRL) {
        MsgOut.vprintln("Parse TA file: " + string);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            if (this.isRaw(bufferedInputStream)) {
                DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
                this.parseRawStream(dataInputStream, string, uRL);
                dataInputStream.close();
                bufferedInputStream.close();
                inputStream.close();
                return;
            }
            LandscapeTokenStream landscapeTokenStream = new LandscapeTokenStream(bufferedInputStream, string);
            while (true) {
                int n;
                if ((n = landscapeTokenStream.nextSection()) == 99) {
                    MsgOut.vprintln("");
                    break;
                }
                try {
                    switch (n) {
                        case 0: {
                            this.schemeSetup = true;
                            this.universalScheme = false;
                            this.processSchemeTuples(landscapeTokenStream);
                            this.updateProgress();
                            break;
                        }
                        case 1: {
                            if (!this.schemeSetup) {
                                this.schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processSchemeAttributes(landscapeTokenStream);
                            this.updateProgress();
                            break;
                        }
                        case 2: {
                            if (!this.schemeSetup) {
                                this.schemeSetup = true;
                                this.setupUniversalScheme();
                            }
                            this.processFactTuples(landscapeTokenStream);
                            break;
                        }
                        case 3: {
                            this.processFactAttributes(landscapeTokenStream);
                            break;
                        }
                        case 4: {
                            if (uRL == null) {
                                this.parseFile(landscapeTokenStream.getIncludeFile(), null);
                            } else {
                                this.parseURL(landscapeTokenStream.getIncludeFile(), uRL);
                            }
                            MsgOut.vprintln("Back to TA file: " + string);
                        }
                    }
                }
                catch (IOException iOException) {
                    MsgOut.println("IO error reading landscape");
                    this.resString = iOException.toString();
                    break;
                }
            }
            bufferedInputStream.close();
            inputStream.close();
        }
        catch (Exception exception) {
            this.resString = exception.toString();
        }
    }

    protected URL parseURL(String string, URL uRL) {
        this.progressCount = 0;
        this.updateProgress();
        try {
            URL uRL2 = uRL == null ? new URL(string) : new URL(uRL, string);
            MsgOut.dprintln("Opening URL: " + string);
            InputStream inputStream = uRL2.openStream();
            MsgOut.dprintln("opened");
            this.parseStream(inputStream, string, uRL2);
            return uRL2;
        }
        catch (Exception exception) {
            this.resString = exception.toString();
            return null;
        }
    }

    protected File parseFile(String string, File file) {
        this.progressCount = 0;
        this.updateProgress();
        try {
            Object object;
            File file2;
            if (file == null) {
                file2 = new File(string);
            } else {
                object = this.getDir(file);
                file2 = new File((String)object, string);
            }
            object = new FileInputStream(file2);
            this.parseStream((InputStream)object, string, null);
            return file2;
        }
        catch (Exception exception) {
            this.resString = exception.toString();
            return null;
        }
    }

    protected void processInternalBuffer(String string) {
        InternalBufferStream internalBufferStream = this.ls.getInternalBufferStream();
        if (internalBufferStream == null) {
            this.resString = "Internal landscape not available";
            return;
        }
        this.parseRawStream(internalBufferStream, string, null);
        this.readOnly = true;
    }

    public Diagram() {
    }

    public Diagram(LandscapeViewerCore landscapeViewerCore, boolean bl) {
        this.clients = new Vector();
        this.suppliers = new Vector();
        this.ls = landscapeViewerCore;
        if (bl) {
            this.undoDg = new Diagram();
        }
        this.undoDg = new Diagram();
        this.drawRoot = this.rootInstance = new BaseEntity(null, ROOT_ID, this);
        this.clientCompareFn.setRoot(this.drawRoot);
        this.supplierCompareFn.setRoot(this.drawRoot);
        this.entityInstances.put(ROOT_ID, this.rootInstance);
        for (int i = 0; i < rootAttributes.length; ++i) {
            this.rootInstance.addAttribute(new Attribute(rootAttributes[i], null));
        }
        AttributeValueItem attributeValueItem = new AttributeValueItem(BG_STR);
        attributeValueItem.next = new AttributeValueItem(BG_STR);
        attributeValueItem.next.next = new AttributeValueItem(BG_STR);
        this.rootInstance.addAttribute(new Attribute("color", attributeValueItem));
        this.entityBaseClass = new EntityClass("$ENTITY", this.numEntityClasses++, null, this);
        this.entityClasses.put("$ENTITY", this.entityBaseClass);
        this.relationBaseClass = new RelationClass("$RELATION", this.numRelationClasses++, null, this);
        this.relationClasses.put("$RELATION", this.relationBaseClass);
        this.numToRel.addElement(this.relationBaseClass);
        RelationClass relationClass = new RelationClass(CONTAIN_ID, this.numRelationClasses++, this.relationBaseClass, this);
        this.relationClasses.put(CONTAIN_ID, relationClass);
        this.numToRel.addElement(relationClass);
    }

    public void run() {
        Enumeration enumeration = this.bgpaths.elements();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            String string = (String)enumeration.nextElement();
            if (Util.isHTTP(string)) {
                serializable = this.parseURL(string, (URL)this.context);
                continue;
            }
            serializable = this.parseFile(string, (File)this.context);
        }
    }

    protected String backgroundLoad(Vector vector) {
        if (vector != null && vector.size() > 0) {
            this.bgpaths = vector;
            Thread thread = new Thread(this);
            thread.start();
        }
        return null;
    }

    protected void setupOption(int n, String string, boolean bl) {
        Attribute attribute = this.rootInstance.getAttribute(string);
        if (attribute.avi == null) {
            attribute.avi = new AttributeValueItem(String.valueOf(bl));
        }
        this.ls.setGlobalOption(n, attribute.parseBoolean());
    }

    public String loadDiagram(String string, Vector vector, Object object) {
        this.resString = null;
        char c = string.charAt(string.length() - 1);
        if (c == File.separatorChar) {
            string = string.substring(0, string.length() - 1);
        }
        if (string.equals("__internal")) {
            this.processInternalBuffer(string);
        } else if (object instanceof URL || Util.isHTTP(string)) {
            MsgOut.dprintln("Parse a URL");
            this.context = this.parseURL(string, (URL)object);
        } else {
            MsgOut.dprintln("Parse a file");
            this.context = this.parseFile(string, (File)object);
        }
        Attribute attribute = this.rootInstance.getAttribute(EDGEMODE_ID);
        if (attribute.avi == null) {
            attribute.avi = new AttributeValueItem(String.valueOf(2));
        }
        LandscapeObject.setEdgeMode(attribute.parseInt());
        this.clientCompareFn.setEdgeMode(attribute.parseInt());
        this.supplierCompareFn.setEdgeMode(attribute.parseInt());
        this.setupOption(1107, TOPCLIENTS_ID, true);
        this.setupOption(1104, WANTCLIENTS_ID, true);
        this.setupOption(1105, WANTSUPPLIERS_ID, true);
        this.setupOption(1106, WANTCARDINALS_ID, false);
        this.relVisibilityAttr = attribute = this.rootInstance.getAttribute(RELN_HIDDEN_ID);
        AttributeValueItem attributeValueItem = attribute.avi;
        while (attributeValueItem != null) {
            RelationClass relationClass = (RelationClass)this.relationClasses.get(attributeValueItem.value);
            relationClass.setVisibleState(false);
            attributeValueItem = attributeValueItem.next;
        }
        this.clients = new Vector();
        this.suppliers = new Vector();
        this.dClients = this.clients;
        this.dSuppliers = this.suppliers;
        this.setVisibilityFlags();
        if (this.context == null) {
            return this.resString;
        }
        return this.backgroundLoad(vector);
    }

    public void saveDiagram(OutputStream outputStream, boolean bl) throws IOException {
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        PrintStream printStream = new PrintStream(bufferedOutputStream);
        this.writeSchemeTuples(printStream);
        this.writeSchemeAttributes(printStream);
        this.writeFactTuples(printStream);
        this.writeFactAttributes(printStream);
        if (bl) {
            printStream.print("END\n");
        }
        printStream.flush();
        printStream.close();
        this.changedFlag = false;
    }

    public void saveDiagramRaw(OutputStream outputStream) throws IOException {
        String string;
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
        DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        Enumeration<Object> enumeration = this.entityClasses.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable.put(string, new Integer(n++));
            vector.addElement(string);
        }
        enumeration = this.relationClasses.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable.put(string, new Integer(n++));
            vector.addElement(string);
        }
        enumeration = this.entityInstances.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable.put(string, new Integer(n++));
            vector.addElement(string);
        }
        enumeration = this.attrNames.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable.put(string, new Integer(n++));
            vector.addElement(string);
        }
        dataOutputStream.writeUTF(RAW_HEADER);
        dataOutputStream.writeInt(vector.size());
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            dataOutputStream.writeUTF((String)enumeration.nextElement());
        }
        this.writeSchemeTuplesRaw(dataOutputStream, hashtable);
        this.writeSchemeAttributesRaw(dataOutputStream, hashtable);
        this.writeFactTuplesRaw(dataOutputStream, hashtable);
        this.writeFactAttributesRaw(dataOutputStream, hashtable);
        dataOutputStream.writeUTF("#END#");
        dataOutputStream.flush();
        dataOutputStream.close();
        bufferedOutputStream.close();
        this.changedFlag = false;
    }

    protected void doSaveForUndo() {
        this.undoDg.ls = this.ls;
        this.undoDg.entityClasses = (Hashtable)this.entityClasses.clone();
        this.undoDg.relationClasses = (Hashtable)this.relationClasses.clone();
        this.undoValid = true;
    }

    public void saveForUndo() {
        this.changedFlag = true;
        this.rootInstance.saveForUndo();
        this.doSaveForUndo();
    }

    public void undo() {
        this.rootInstance.undo();
        Diagram diagram = this.undoDg;
        this.undoDg = new Diagram();
        this.doSaveForUndo();
        this.entityClasses = diagram.entityClasses;
        this.relationClasses = diagram.relationClasses;
    }

    public boolean isUndoAvailable() {
        return this.undoValid;
    }

    public void saveLayout() {
        this.rootInstance.saveLayout();
    }

    public void restoreLayout() {
        this.rootInstance.restoreLayout();
    }

    public void clearCache() {
        this.rootInstance.clearCache();
    }

    public void processClientSuppliers(Graphics graphics, Vector vector, double d, double d2, boolean bl) {
        double d3;
        double d4;
        Enumeration enumeration = vector.elements();
        double d5 = this.calcWidth(graphics, vector, 0);
        if (d5 <= (double)(this.width - 20)) {
            d4 = ((double)(this.width - 5) - d5) / 2.0;
            d3 = 1.0;
        } else {
            d4 = 5.0;
            d3 = (double)(this.width - 20) / d5;
        }
        boolean bl2 = this.ls.getOption(1106);
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Dimension dimension = entityInstance.getFitDim(graphics, 0, true);
            Layout layout = entityInstance.getLayout();
            layout.width = (double)dimension.width * d3;
            layout.height = dimension.height;
            layout.x = d4 * d3;
            layout.y = d2;
            entityInstance.setGlobalLayout(layout);
            Layout layout2 = entityInstance.getLocalLayout();
            entityInstance.rescaleChildren(layout.width / layout2.width, layout.height / layout2.height, d4, d2);
            entityInstance.drawAll(graphics);
            entityInstance.drawLabel(graphics, 0, true);
            if (!bl && bl2) {
                entityInstance.drawCardinals(graphics);
            }
            d4 += (double)(dimension.width + 5);
        }
    }

    public void sortClients(Vector vector) {
        if (vector.size() > 1 && !this.clientsSorted) {
            Util.sortVector(vector, this.clientCompareFn, true);
            this.clientsSorted = true;
        }
    }

    public void drawClients(Graphics graphics) {
        if (this.dClients != null && this.dClients.size() > 0) {
            Layout layout = this.drawRoot.getLayout();
            double d = Math.max(50.0, (double)this.height - layout.y - layout.height - 50.0);
            this.sortClients(this.dClients);
            this.processClientSuppliers(graphics, this.dClients, d, this.getClientSupplierPos(15.0, (double)this.height - d - 15.0), true);
            if (!this.allClients) {
                graphics.setFont(EntityInstance.getSmallFont());
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = Util.fontHeight(fontMetrics);
                n += n / 2;
                graphics.setColor(Color.black);
                Util.drawStringClipped(graphics, "Showing only external clients. Siblings and their descendents are not shown.", 10.0, this.getClientSupplierPos(-n, (double)this.height - d + (double)n), this.width - 20, n, true, false);
            }
        } else if (this.clients != null && this.clients.size() > 0) {
            graphics.setFont(EntityInstance.getSmallFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = Util.fontHeight(fontMetrics);
            n += n / 2;
            graphics.setColor(Color.black);
            Util.drawStringClipped(graphics, "All clients are also suppliers", 10.0, this.getClientSupplierPos(5.0, this.height - 5), this.width - 20, n, true, false);
        }
    }

    public void sortSuppliers(Vector vector) {
        if (vector.size() > 1 && !this.suppliersSorted) {
            Util.sortVector(vector, this.supplierCompareFn, true);
            this.suppliersSorted = true;
        }
    }

    public void drawSuppliers(Graphics graphics) {
        if (this.dSuppliers != null && this.dSuppliers.size() > 0) {
            Layout layout = this.drawRoot.getLayout();
            double d = Math.max(50.0, layout.y - 50.0);
            this.sortSuppliers(this.dSuppliers);
            this.processClientSuppliers(graphics, this.dSuppliers, d, this.getClientSupplierPos((double)this.height - d - 10.0, 10.0), false);
            if (!this.allSuppliers) {
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n = Util.fontHeight(fontMetrics);
                n += n / 2;
                graphics.setColor(Color.black);
                Util.drawStringClipped(graphics, "Showing only external suppliers. Siblings and their descendents are not shown.", 10.0, this.getClientSupplierPos((double)this.height - d + (double)n, 10.0), this.width - 20, n, true, false);
            }
        }
    }

    protected void drawExitFlag(Graphics graphics) {
        graphics.setColor(boxColour.darker());
        graphics.drawRect(3, 3, 8, 8);
        graphics.drawLine(5, 7, 9, 7);
    }

    protected void doDraw(Graphics graphics, EntityInstance entityInstance, boolean bl) {
        Rectangle rectangle = graphics.getClipRect();
        Rectangle rectangle2 = this.bounds();
        this.clearCache();
        this.drawCache = new DrawCache(this.entityInstances.size(), this.relationClasses.size());
        ++this.timeStamp;
        if (bl) {
            entityInstance.drawAll(graphics);
        } else {
            entityInstance.drawChildren(graphics);
        }
        boolean bl2 = this.ls.getOption(1106);
        if (bl2) {
            this.rootInstance.resetCardinals(this.numRelationClasses);
            entityInstance.calcEdgeCardinals(!this.drawEdges);
        }
        if (this.drawRoot.getParent() != null) {
            this.drawExitFlag(graphics);
        }
        this.drawClients(graphics);
        this.drawSuppliers(graphics);
        if (this.drawEdges) {
            if (this.visibleEdges) {
                entityInstance.drawEdges(graphics);
                if (entityInstance != this.drawRoot && entityInstance.isOpen()) {
                    // empty if block
                }
            }
        } else {
            entityInstance.drawHighlightedEdges(graphics);
        }
        entityInstance.drawLabels(graphics);
        if (bl2) {
            entityInstance.drawCardinals(graphics);
        }
    }

    public void draw(Graphics graphics) {
        this.doDraw(graphics, this.drawRoot, true);
    }

    public void draw(Graphics graphics, EntityInstance entityInstance) {
        if (this.isClient(entityInstance)) {
            this.drawClients(graphics);
        } else if (this.isSupplier(entityInstance)) {
            this.drawSuppliers(graphics);
        } else {
            this.doDraw(graphics, entityInstance, true);
        }
    }

    public void move(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public void resize(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void rescale(int n, int n2) {
        this.xoffset = n;
        this.yoffset = n2;
        this.rootInstance.rescale(this.xScale, this.yScale, n, n2);
    }

    public void rescale() {
        this.rootInstance.rescale(this.xScale, this.yScale, this.xoffset, this.yoffset);
    }

    public boolean isMouseOver(int n, int n2) {
        return n >= 0 && n <= this.width && n2 >= 0 && n2 <= this.height;
    }

    public RelationInstance mouseOverEdge(EntityInstance entityInstance, int n, int n2) {
        if (entityInstance == null) {
            return null;
        }
        if (this.drawEdges && !this.visibleEdges) {
            return null;
        }
        return entityInstance.getMouseOverEdge(n, n2, this.timeStamp);
    }

    public RelationInstance mouseOverAnyEdge(EntityInstance entityInstance, int n, int n2) {
        if (entityInstance == null) {
            return null;
        }
        return entityInstance.getMouseOverEdge(n, n2, -1);
    }

    public RelationInstance mouseOverEdge(int n, int n2) {
        return this.mouseOverEdge(this.drawRoot, n, n2);
    }

    protected void mouseOverAllEdges(EntityInstance entityInstance, int n, int n2, Vector vector) {
        entityInstance.getMouseOverAllEdges(n, n2, vector);
        Enumeration enumeration = entityInstance.getChildren();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            this.mouseOverAllEdges(entityInstance2, n, n2, vector);
        }
    }

    public Vector mouseOverAllEdges(int n, int n2) {
        Vector vector = new Vector();
        this.mouseOverAllEdges(this.drawRoot, n, n2, vector);
        return vector;
    }

    public EdgePoint mouseOverIO(EntityInstance entityInstance, int n, int n2) {
        if (this.drawBends && entityInstance != null && entityInstance.isOpen()) {
            EdgePoint edgePoint = entityInstance.getMouseOverIO(n, n2);
            if (edgePoint != null) {
                return edgePoint;
            }
            Enumeration enumeration = entityInstance.getChildren();
            while (enumeration.hasMoreElements()) {
                EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
                edgePoint = entityInstance2.getMouseOverIO(n, n2);
                if (edgePoint == null) continue;
                return edgePoint;
            }
        }
        return null;
    }

    public boolean mouseOverEnterExit(EntityInstance entityInstance, int n, int n2) {
        if (entityInstance == null) {
            return false;
        }
        EntityInstance entityInstance2 = this.drawRoot.getParent();
        if (entityInstance == entityInstance2) {
            if (n >= 3 && n <= 11 && n2 >= 3 && n2 <= 11) {
                return true;
            }
        } else if (entityInstance.isEnterable() && entityInstance.hasChildren() && !entityInstance.isOpen()) {
            Layout layout = entityInstance.getLayout();
            if ((double)n >= layout.x + 3.0 && (double)n <= layout.x + 8.0 + 3.0 && (double)n2 >= layout.y + 3.0 && (double)n2 <= layout.y + 8.0 + 3.0) {
                return true;
            }
        }
        return false;
    }

    public Bend newBend(EntityInstance entityInstance, RelationInstance relationInstance, double d, double d2, boolean bl) {
        Bend bend;
        Enumeration enumeration = this.globalBends.elements();
        while (enumeration.hasMoreElements()) {
            boolean bl2;
            bend = (Bend)enumeration.nextElement();
            if (bl) {
                bl2 = bend.e == entityInstance && Math.abs(bend.x - d) < 0.1 && Math.abs(bend.y - d2) < 0.1;
            } else {
                boolean bl3 = bl2 = bend.e == entityInstance && Math.abs(bend.xLocal - d) < 0.1 && Math.abs(bend.yLocal - d2) < 0.1;
            }
            if (!bl2) continue;
            bend.addRelation(relationInstance);
            return bend;
        }
        bend = new Bend(entityInstance, relationInstance, d, d2, bl);
        this.globalBends.addElement(bend);
        return bend;
    }

    public Bend addBend(RelationInstance relationInstance, int n, int n2) {
        EntityInstance entityInstance = this.mouseOverEx(n, n2);
        Bend bend = new Bend(entityInstance, relationInstance, n, n2);
        entityInstance.addBend(bend, this.xScale, this.yScale);
        relationInstance.addBend(bend);
        Vector vector = this.mouseOverAllEdges(n, n2);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance2 = (RelationInstance)enumeration.nextElement();
            if (bend.hasRelation(relationInstance2)) continue;
            bend.addRelation(relationInstance2);
            relationInstance.addBend(bend);
        }
        return bend;
    }

    public void deleteBend(Bend bend) {
        bend.delete();
    }

    public void moveBend(Bend bend, int n, int n2) {
        EntityInstance entityInstance = this.mouseOverEx(n, n2);
        if (entityInstance != null) {
            bend.move(n, n2);
            if (entityInstance == bend.e) {
                bend.e.moveBend(bend, this.xScale, this.yScale);
            } else {
                bend.e.deleteBend(bend);
                bend.e = entityInstance;
                entityInstance.addBend(bend, this.xScale, this.yScale);
            }
        }
    }

    public void deleteEdge(RelationInstance relationInstance) {
        Enumeration enumeration = relationInstance.getBends();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Bend bend = (Bend)enumeration.nextElement();
                bend.e.deleteBend(bend);
            }
        }
        relationInstance.getSrc().removeSrcRelation(relationInstance);
        relationInstance.getDst().removeDstRelation(relationInstance);
    }

    public Bend mouseOverBend(int n, int n2) {
        return this.drawRoot.getMouseOverBend(n, n2);
    }

    public EntityInstance mouseOverEntity(int n, int n2) {
        EntityInstance entityInstance;
        if (this.dClients == null) {
            return null;
        }
        Enumeration enumeration = this.dClients.elements();
        EntityInstance entityInstance2 = null;
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance2 = entityInstance.getMouseOver(n, n2);
            if (entityInstance2 == null) continue;
            return entityInstance2;
        }
        enumeration = this.dSuppliers.elements();
        while (enumeration.hasMoreElements()) {
            entityInstance = (EntityInstance)enumeration.nextElement();
            entityInstance2 = entityInstance.getMouseOver(n, n2);
            if (entityInstance2 == null) continue;
            return entityInstance2;
        }
        return this.drawRoot.getMouseOver(n, n2);
    }

    public EntityInstance mouseOver(int n, int n2) {
        EntityInstance entityInstance = this.mouseOverEntity(n, n2);
        return entityInstance == this.rootInstance ? null : entityInstance;
    }

    public EntityInstance mouseOver(Point point) {
        return this.mouseOver(point.x, point.y);
    }

    public EntityInstance mouseOverEx(int n, int n2) {
        if (!this.isMouseOver(n, n2)) {
            return null;
        }
        EntityInstance entityInstance = this.mouseOverEntity(n, n2);
        if (entityInstance == null) {
            entityInstance = this.drawRoot.getParent();
        }
        return entityInstance;
    }

    public EntityInstance mouseOverEx(Point point) {
        return this.mouseOverEx(point.x, point.y);
    }

    public EntityInstance intersects(Layout layout) {
        return this.drawRoot.intersects(layout);
    }

    public EntityInstance containing(Layout layout) {
        return this.drawRoot.containing(layout);
    }

    public Vector setGroupRegion(Layout layout) {
        EntityInstance entityInstance = this.drawRoot.getMouseOver((int)layout.x, (int)layout.y);
        if (entityInstance == null) {
            return null;
        }
        return entityInstance.groupRegion(layout);
    }

    public boolean zoomIn(double d) {
        double d2 = this.xScale * d;
        double d3 = this.yScale * d;
        this.xScale = d2;
        this.yScale = d3;
        this.rescale();
        return true;
    }

    public boolean zoomOut(double d) {
        double d2 = this.xScale * d;
        double d3 = this.yScale * d;
        this.xScale = d2;
        this.yScale = d3;
        this.rescale();
        return true;
    }

    public boolean scaleX(double d) {
        double d2;
        this.xScale = d2 = this.xScale * d;
        this.rescale();
        return true;
    }

    public boolean scaleY(double d) {
        double d2;
        this.yScale = d2 = this.yScale * d;
        this.rescale();
        return true;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setDrawBends(boolean bl) {
        MsgOut.dprintln("Draw bends set to: " + bl);
        this.drawBends = bl;
    }

    public boolean isDrawBends() {
        return this.drawBends;
    }

    public void setEdgeMode(int n) {
        LandscapeObject.setEdgeMode(n);
        this.clientCompareFn.setEdgeMode(n);
        this.supplierCompareFn.setEdgeMode(n);
        Attribute attribute = this.rootInstance.getAttribute(EDGEMODE_ID);
        attribute.avi = new AttributeValueItem(String.valueOf(n));
    }

    public int getEdgeMode() {
        return LandscapeObject.getEdgeMode();
    }

    public double getScaleX() {
        return this.xScale;
    }

    public double getScaleY() {
        return this.yScale;
    }

    public void setScaleX(double d) {
        this.xScale = d;
    }

    public void setScaleY(double d) {
        this.yScale = d;
    }

    public EntityInstance getRoot() {
        return this.drawRoot;
    }

    public EntityInstance getTopInstance() {
        return this.rootInstance;
    }

    public Layout calcRootLayout() {
        return null;
    }

    public int getTop() {
        return this.yoffset;
    }

    public int getTimeStamp() {
        return this.timeStamp;
    }

    public boolean excludeReln(RelationClass relationClass) {
        String string = relationClass.getId();
        return string.equals(CONTAIN_ID) || string.equals("$RELATION");
    }

    public void toggleInElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (this.excludeReln(relationClass) || !relationClass.isVisible()) continue;
            entityInstance.toggleInElision(relationClass);
        }
    }

    public void toggleOutElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (this.excludeReln(relationClass) || !relationClass.isVisible()) continue;
            entityInstance.toggleOutElision(relationClass);
        }
    }

    public void toggleClientElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (this.excludeReln(relationClass) || !relationClass.isVisible()) continue;
            entityInstance.toggleClientElision(relationClass);
        }
    }

    public void toggleSupplierElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (this.excludeReln(relationClass) || !relationClass.isVisible()) continue;
            entityInstance.toggleSupplierElision(relationClass);
        }
    }

    public void toggleInternalElision(EntityInstance entityInstance) {
        Enumeration enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (this.excludeReln(relationClass) || !relationClass.isVisible()) continue;
            entityInstance.toggleInternalElision(relationClass);
        }
    }

    public void toggleContainElision(EntityInstance entityInstance) {
        MsgOut.dprintln("Toggle contains elision on " + entityInstance.getLabel());
        entityInstance.toggleInElision(CONTAIN_ID);
    }

    public boolean setContainElision(EntityInstance entityInstance, boolean bl) {
        if (entityInstance.canOpen() && (entityInstance.isOpen() && !bl || !entityInstance.isOpen() && bl)) {
            this.toggleContainElision(entityInstance);
            return true;
        }
        return false;
    }

    public void toggleAggElision(EntityInstance entityInstance) {
        MsgOut.dprintln("Toggle aggregation elision on " + entityInstance.getLabel());
        entityInstance.toggleInElision("aggelision");
    }

    public void setEdgeActiveState(RelationClass relationClass, boolean bl) {
        relationClass.setActiveState(bl);
    }

    public void setEdgeVisibilityState(RelationClass relationClass, boolean bl) {
        relationClass.setVisibleState(bl);
        if (bl) {
            this.relVisibilityAttr.removeFromList(relationClass.getId());
        } else {
            this.relVisibilityAttr.addToList(relationClass.getId());
        }
        this.setVisibilityFlags();
    }

    public void toggleEdgeVisibility() {
        Enumeration enumeration = this.enumRelations();
        while (enumeration.hasMoreElements()) {
            RelationClass relationClass = (RelationClass)enumeration.nextElement();
            if (this.excludeReln(relationClass) || !relationClass.isVisible()) continue;
            boolean bl = !relationClass.isVisible();
            this.setEdgeVisibilityState(relationClass, bl);
        }
    }

    public void setForHighlightEdges() {
        this.drawEdges = false;
    }

    public Vector getHighlightedEdges() {
        Vector vector = new Vector();
        this.drawRoot.getHighlightedEdges(vector);
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public boolean clearFlags() {
        this.keyEntity = null;
        boolean bl = false;
        if (!this.drawEdges) {
            bl = true;
            this.drawEdges = true;
        }
        return bl |= this.rootInstance.clearAllFlags();
    }

    public boolean clearQueryFlags() {
        return this.rootInstance.clearHighlightFlags();
    }

    public void clearGroupFlags() {
        this.keyEntity = null;
        this.drawEdges = true;
        this.rootInstance.clearGroupFlags();
    }

    public boolean toggleQueryPersistence() {
        this.persistentQuery = !this.persistentQuery;
        return this.persistentQuery;
    }

    public boolean getQueryPersistance() {
        return this.persistentQuery;
    }

    public boolean edgeSrcValid(EntityInstance entityInstance) {
        return true;
    }

    public boolean edgeDstValid(EntityInstance entityInstance) {
        return true;
    }

    public boolean edgePresent(EntityInstance entityInstance, EntityInstance entityInstance2) {
        return false;
    }

    public void setDrawEdges(boolean bl) {
        this.drawEdges = bl;
    }

    public void drawCreateEdge(Graphics graphics, EntityInstance entityInstance, int n, int n2) {
        entityInstance.drawSegment(graphics, n, n2);
    }

    public void addEdge(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass) {
        RelationInstance relationInstance = relationClass.newRelation(entityInstance, entityInstance2, this);
        entityInstance.addRelation(relationInstance, entityInstance2);
    }

    public EntityInstance addEntity(String string, String string2, String string3, Layout layout, EntityInstance entityInstance, EntityClass entityClass, Vector vector) {
        EntityInstance entityInstance2 = entityClass.newEntity(string, this);
        entityInstance2.setNid(this.entityInstances.size());
        this.entityInstances.put(string, entityInstance2);
        entityInstance.addContainment(entityInstance2);
        entityInstance2.setLayout(layout);
        entityInstance2.setLabel(string2);
        entityInstance2.setDescription(string3);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance3 = (EntityInstance)enumeration.nextElement();
            Layout layout2 = entityInstance3.getLayout();
            entityInstance.removeContainment(entityInstance3);
            entityInstance2.addContainment(entityInstance3);
            entityInstance3.setLayout(layout2);
        }
        this.rescale();
        return entityInstance2;
    }

    public EntityInstance addEntity(String string, Layout layout, EntityInstance entityInstance) {
        EntityInfo entityInfo = EditNewEntityDialog.Create(this.ls, this.defaultEntityClass, string);
        if (entityInfo == null) {
            return null;
        }
        return this.addEntity(entityInfo.id, entityInfo.label, entityInfo.desc, layout, entityInstance, entityInfo.ec, new Vector());
    }

    public RelationClass nameToRelationClass(String string) {
        if (this.relationClasses.containsKey(string)) {
            return (RelationClass)this.relationClasses.get(string);
        }
        return null;
    }

    public Enumeration enumRelations() {
        return new OrderedHashTableEnumeration(this.relationClasses);
    }

    public int numRelationClasses() {
        return this.numRelationClasses;
    }

    public int numVisibleRelationClasses() {
        return this.numVisibleRelationClasses;
    }

    public RelationClass getContainsClass() {
        return (RelationClass)this.relationClasses.get(CONTAIN_ID);
    }

    public Enumeration enumEntityClasses() {
        return new OrderedHashTableEnumeration(this.entityClasses);
    }

    public int numEntityClasses() {
        return this.numEntityClasses;
    }

    public Enumeration enumEntities() {
        return this.entityInstances.elements();
    }

    public void drawEntityOutline(Graphics graphics, Layout layout, EntityInstance entityInstance) {
        entityInstance.drawOutline(graphics, layout);
    }

    public void drawEntityHighlight(Graphics graphics, EntityInstance entityInstance) {
        entityInstance.drawHighlight(graphics);
    }

    public void undrawEntityHighlight(Graphics graphics, EntityInstance entityInstance) {
        entityInstance.undrawHighlight(graphics);
    }

    public void drawEdge(Graphics graphics, RelationInstance relationInstance) {
        relationInstance.draw(graphics);
    }

    public void enter(EntityInstance entityInstance) {
        this.rootInstance = entityInstance;
        this.drawRoot = entityInstance;
    }

    public Object getContext() {
        return this.context;
    }

    public Object setContext(Object object) {
        this.context = object;
        return this.context;
    }

    public String getName() {
        if (this.context instanceof File) {
            return Util.nameFromPath(((File)this.context).getPath());
        }
        return this.rootInstance.getLabel();
    }

    public String getDir(File file) {
        if (file.isAbsolute()) {
            return file.getParent();
        }
        return new File(file.getAbsolutePath()).getParent();
    }

    public String getDir() {
        return this.getDir((File)this.context);
    }

    public String getAbsolutePath() {
        if (this.context instanceof File) {
            return ((File)this.context).getAbsolutePath();
        }
        return ((URL)this.context).toExternalForm();
    }

    public Vector getGroup() {
        Vector vector = new Vector();
        this.rootInstance.getGroup(vector);
        if (vector.isEmpty()) {
            return null;
        }
        return vector;
    }

    public Layout getGroupBoundingBox() {
        Vector vector = this.getGroup();
        if (vector == null || vector.isEmpty()) {
            return null;
        }
        Enumeration enumeration = vector.elements();
        double d = Double.MAX_VALUE;
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MIN_VALUE;
        double d4 = Double.MIN_VALUE;
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Layout layout = entityInstance.getLayout();
            if (layout.x < d) {
                d = layout.x;
            }
            if (layout.y < d2) {
                d2 = layout.y;
            }
            if (layout.x + layout.width > d3) {
                d3 = layout.x + layout.width;
            }
            if (!(layout.y + layout.height > d4)) continue;
            d4 = layout.y + layout.height;
        }
        return new Layout(d, d2, d3 - d, d4 - d2);
    }

    public EntityInstance getKeyEntity() {
        return this.keyEntity;
    }

    public void setKeyEntity(EntityInstance entityInstance) {
        if (this.keyEntity != null) {
            this.keyEntity.clearGroupKeyFlag();
            this.keyEntity.setGroupFlag();
        }
        this.keyEntity = entityInstance;
        this.keyEntity.setGroupKeyFlag();
        this.keyEntity.setGroupFlag();
    }

    public Vector getHighlightGroup() {
        Vector vector = new Vector();
        this.drawRoot.getHighlightGroup(vector);
        if (vector.isEmpty()) {
            return null;
        }
        return vector;
    }

    public void selectEdges(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            RelationInstance relationInstance = (RelationInstance)enumeration.nextElement();
            relationInstance.setHighlightFlag();
            relationInstance.setGroupFlag();
        }
        this.drawEdges = false;
    }

    public boolean isOverGroupRegion(int n, int n2) {
        Layout layout = this.getGroupBoundingBox();
        if (layout != null) {
            return layout.isOver(n, n2);
        }
        return false;
    }

    public boolean isOverGrabRegion(EntityInstance entityInstance, int n, int n2) {
        if (entityInstance == this.rootInstance) {
            return false;
        }
        ScreenLayout screenLayout = new ScreenLayout(entityInstance.getLayout());
        int n3 = n - screenLayout.x;
        int n4 = screenLayout.x + screenLayout.width - n;
        int n5 = n2 - screenLayout.y;
        int n6 = screenLayout.y + screenLayout.height - n2;
        int n7 = Math.min(screenLayout.width / 4, 20);
        int n8 = Math.min(screenLayout.height / 4, 20);
        return n3 > 0 && n3 < n7 || n4 > 0 && n4 < n7 || n5 > 0 && n5 < n8 || n6 > 0 && n6 < n8;
    }

    public boolean isOverLabel(EntityInstance entityInstance, int n, int n2) {
        return false;
    }

    public int getGrid() {
        return this.gridPixels;
    }

    public void setGrid(int n) {
        this.gridPixels = n;
    }

    public void flagChanged() {
        this.changedFlag = true;
    }

    public boolean getChangedFlag() {
        return this.changedFlag;
    }

    public void resetChangedFlag() {
        this.changedFlag = false;
    }

    public void setToViewport() {
        Layout layout = this.rootInstance.getChildBoundingBoxLocal();
        if (layout != null) {
            this.xScale = (double)this.width / layout.width * 0.9375;
            this.yScale = (double)this.height / layout.height * 0.9375;
            double d = 20.0 / this.xScale - layout.x;
            double d2 = 20.0 / this.yScale - layout.y;
            this.rootInstance.translateChildrenLocal(d, d2);
            this.yoffset = 0;
            this.xoffset = 0;
            this.rescale();
            this.rootInstance.setLayout(new Layout(0.0, 0.0, this.width, this.height));
        }
        this.rootInstance.verifyFit();
    }

    public void fitTo(EntityInstance entityInstance) {
        entityInstance.fitTo(true);
        this.rescale();
    }

    public void navigateTo(EntityInstance entityInstance) {
        this.clearCache();
        if (this.rootInstance == this.drawRoot) {
            this.topXscale = this.xScale;
            this.topYscale = this.yScale;
        } else {
            this.xScale = this.topXscale;
            this.yScale = this.topYscale;
            this.yoffset = 0;
            this.xoffset = 0;
            this.rescale();
        }
        this.drawRoot = entityInstance;
        if (entityInstance == this.rootInstance) {
            this.clients = new Vector();
            this.suppliers = new Vector();
            this.dClients = this.clients;
            this.dSuppliers = this.suppliers;
        } else {
            this.findClientsAndSuppliers();
            this.clientsSorted = false;
            this.suppliersSorted = false;
            double d = this.width - 30;
            double d2 = this.height - 20;
            if (this.clients.size() > 0) {
                d2 -= 70.0;
            }
            if (this.suppliers.size() > 0) {
                d2 -= 70.0;
            }
            double d3 = d / entityInstance.width();
            double d4 = d2 / entityInstance.height();
            double d5 = Math.min(d3, d4);
            this.xScale *= d5;
            this.yScale *= d5;
            this.rescale(0, 0);
            this.xoffset = (int)(((double)this.width - entityInstance.width()) / 2.0 - entityInstance.x());
            this.yoffset = (int)(((double)this.height - entityInstance.height()) / 2.0 - entityInstance.y());
            double d6 = 35.0;
            if (this.isTopClients()) {
                d6 = -d6;
            }
            if (this.dClients.size() == 0 && this.dSuppliers.size() > 0) {
                this.yoffset = (int)((double)this.yoffset + d6);
            } else if (this.dClients.size() > 0 && this.dSuppliers.size() == 0) {
                this.yoffset = (int)((double)this.yoffset - d6);
            }
        }
        this.clearFlags();
        this.clientCompareFn.setRoot(this.drawRoot);
        this.supplierCompareFn.setRoot(this.drawRoot);
        this.rescale();
    }

    public boolean navigateTo(String string) {
        EntityInstance entityInstance = (EntityInstance)this.entityInstances.get(string);
        if (entityInstance == null) {
            return false;
        }
        this.navigateTo(entityInstance);
        return true;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly() {
        this.readOnly = true;
    }

    public boolean entityExists(String string) {
        EntityInstance entityInstance = (EntityInstance)this.entityInstances.get(string);
        return entityInstance != null;
    }

    public LandscapeViewerCore getLs() {
        return this.ls;
    }

    public boolean isClient(EntityInstance entityInstance) {
        return this.clients.contains(entityInstance);
    }

    public boolean isSupplier(EntityInstance entityInstance) {
        return this.suppliers.contains(entityInstance);
    }

    public boolean isClientOrSupplier(EntityInstance entityInstance) {
        return this.isClient(entityInstance) || this.isSupplier(entityInstance);
    }

    public EntityInstance getClient(EntityInstance entityInstance) {
        if (this.isClient(entityInstance)) {
            return entityInstance;
        }
        Enumeration enumeration = this.clients.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (!entityInstance2.descendent(entityInstance)) continue;
            return entityInstance2;
        }
        return null;
    }

    public EntityInstance getSupplier(EntityInstance entityInstance) {
        if (this.isSupplier(entityInstance)) {
            return entityInstance;
        }
        Enumeration enumeration = this.suppliers.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance2 = (EntityInstance)enumeration.nextElement();
            if (!entityInstance2.descendent(entityInstance)) continue;
            return entityInstance2;
        }
        return null;
    }

    public EntityInstance getClientOrSupplier(EntityInstance entityInstance) {
        EntityInstance entityInstance2 = this.getClient(entityInstance);
        if (entityInstance2 == null) {
            entityInstance2 = this.getSupplier(entityInstance);
        }
        return entityInstance2;
    }

    public boolean isClientDescendent(EntityInstance entityInstance) {
        return this.getClient(entityInstance) != null;
    }

    public boolean isSupplierDescendent(EntityInstance entityInstance) {
        return this.getSupplier(entityInstance) != null;
    }

    public RelationClass numToRelationClass(int n) {
        return (RelationClass)this.numToRel.elementAt(n);
    }

    public boolean allowElision() {
        return this.drawEdges;
    }

    public void setEntitiesColorWhenOpen(EntityClass entityClass, Color color) {
        Enumeration enumeration = this.entityInstances.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.parentClass != entityClass) continue;
            entityInstance.setObjectColorWhenOpen(color);
        }
    }

    public void setEntitiesColor(EntityClass entityClass, Color color) {
        Enumeration enumeration = this.entityInstances.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.parentClass != entityClass) continue;
            entityInstance.setObjectColor(color);
        }
    }

    public void setEntitiesLabelColor(EntityClass entityClass, Color color) {
        Enumeration enumeration = this.entityInstances.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.parentClass != entityClass) continue;
            entityInstance.setLabelColor(color);
        }
    }

    public void setEntitiesStyle(EntityClass entityClass, int n) {
        Enumeration enumeration = this.entityInstances.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            if (entityInstance.parentClass != entityClass) continue;
            entityInstance.style = n;
        }
    }

    public void setRelationColor(RelationClass relationClass, Color color) {
        Enumeration enumeration = this.entityInstances.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Enumeration enumeration2 = entityInstance.srcRelationElements();
            if (enumeration2 == null) continue;
            while (enumeration2.hasMoreElements()) {
                RelationInstance relationInstance = (RelationInstance)enumeration2.nextElement();
                if (relationInstance.parentClass != relationClass) continue;
                relationInstance.setObjectColor(color);
            }
        }
    }

    public void setRelationStyle(RelationClass relationClass, int n) {
        Enumeration enumeration = this.entityInstances.elements();
        while (enumeration.hasMoreElements()) {
            EntityInstance entityInstance = (EntityInstance)enumeration.nextElement();
            Enumeration enumeration2 = entityInstance.srcRelationElements();
            if (enumeration2 == null) continue;
            while (enumeration2.hasMoreElements()) {
                RelationInstance relationInstance = (RelationInstance)enumeration2.nextElement();
                if (relationInstance.parentClass != relationClass) continue;
                relationInstance.style = n;
            }
        }
    }

    public Enumeration clientsEnumerator() {
        if (this.clients != null) {
            return this.clients.elements();
        }
        return null;
    }

    public Enumeration suppliersEnumerator() {
        if (this.suppliers != null) {
            return this.suppliers.elements();
        }
        return null;
    }
}

