/*
 * Decompiled with CFR 0.152.
 */
package lsedit;

import java.awt.Graphics;
import java.util.Hashtable;
import lsedit.EntityInstance;
import lsedit.LineWalker;
import lsedit.PSGr;
import lsedit.RelationClass;
import lsedit.ScreenPoint;
import lsedit.Util;

public class DrawCache {
    protected static final int MAX_HANDLED_ENTITIES = 5000;
    protected static final int DASH_LEN = 4;
    protected static final int DASH_GAP = 3;
    protected static final int DOT_LEN_REG = 0;
    protected static final int DOT_LEN_PRNT = 1;
    protected static final int DOT_GAP = 4;
    protected int edges = 0;
    protected int drawn = 0;
    protected Hashtable m_drawnCache = new Hashtable();

    protected int getDotLen(Graphics graphics) {
        if (graphics instanceof PSGr) {
            return 1;
        }
        return 0;
    }

    private void drawLine(Graphics graphics, LineWalker lineWalker) {
        ScreenPoint screenPoint = new ScreenPoint(0.0, 0.0);
        ScreenPoint screenPoint2 = new ScreenPoint(0.0, 0.0);
        while (lineWalker.morePoints()) {
            lineWalker.nextPoints(screenPoint, screenPoint2);
            graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint2.x, screenPoint2.y);
        }
    }

    protected void drawDashed(Graphics graphics, ScreenPoint screenPoint, ScreenPoint screenPoint2) {
        LineWalker lineWalker = new LineWalker(screenPoint, screenPoint2, 4, 3);
        this.drawLine(graphics, lineWalker);
    }

    protected void drawDotted(Graphics graphics, ScreenPoint screenPoint, ScreenPoint screenPoint2) {
        LineWalker lineWalker = new LineWalker(screenPoint, screenPoint2, this.getDotLen(graphics), 4);
        this.drawLine(graphics, lineWalker);
    }

    protected void doDraw(Graphics graphics, int n, ScreenPoint screenPoint, ScreenPoint screenPoint2) {
        switch (n) {
            case 0: {
                graphics.drawLine(screenPoint.x, screenPoint.y, screenPoint2.x, screenPoint2.y);
                break;
            }
            case 2: {
                this.drawDotted(graphics, screenPoint, screenPoint2);
                break;
            }
            case 1: {
                this.drawDashed(graphics, screenPoint, screenPoint2);
            }
        }
    }

    public DrawCache(int n, int n2) {
    }

    public boolean drawSegment(Graphics graphics, int n, ScreenPoint screenPoint, ScreenPoint screenPoint2) {
        this.doDraw(graphics, n, screenPoint, screenPoint2);
        return true;
    }

    public boolean haveDrawn(EntityInstance entityInstance, EntityInstance entityInstance2, RelationClass relationClass) {
        ++this.edges;
        String string = Util.hashEdge(relationClass, entityInstance, entityInstance2);
        if (this.m_drawnCache.contains(string)) {
            return true;
        }
        this.m_drawnCache.put(string, string);
        ++this.drawn;
        return false;
    }

    public void printStats() {
        System.out.println("Edges: " + this.edges + " drawn: " + this.drawn);
    }
}

